/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.aop;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jboss.cache.Fqn;

public class AOPInstance
implements Serializable {
    public static final Object KEY = "AOPInstance";
    public static final int INITIAL_COUNTER_VALUE = -1;
    static final long serialVersionUID = 6492134565825613209L;
    protected transient Object instance_;
    protected String refFqn_ = null;
    protected int refCount_ = -1;
    protected List referencingFqnList_ = null;

    public AOPInstance() {
    }

    public AOPInstance(Object instance) {
        this.set(instance);
    }

    Object get() {
        return this.instance_;
    }

    void set(Object instance) {
        this.instance_ = instance;
    }

    String getRefFqn() {
        return this.refFqn_;
    }

    void setRefFqn(String refFqn) {
        this.refFqn_ = refFqn;
    }

    void removeRefFqn() {
        this.refFqn_ = null;
    }

    synchronized int incrementRefCount(Fqn referencingFqn) {
        if (referencingFqn != null) {
            if (this.referencingFqnList_ == null) {
                this.referencingFqnList_ = new ArrayList();
            }
            if (this.referencingFqnList_.contains(referencingFqn)) {
                throw new IllegalStateException("AOPInstance.incrementRefCount(): source fqn: " + referencingFqn + " is already present.");
            }
            this.referencingFqnList_.add(referencingFqn);
        }
        ++this.refCount_;
        return this.refCount_;
    }

    synchronized int decrementRefCount(Fqn sourceFqn) {
        if (sourceFqn != null) {
            if (!this.referencingFqnList_.contains(sourceFqn)) {
                throw new IllegalStateException("AOPInstance.decrementRefCount(): source fqn: " + sourceFqn + " is not present.");
            }
            this.referencingFqnList_.remove(sourceFqn);
        }
        --this.refCount_;
        return this.refCount_;
    }

    synchronized int getRefCount() {
        return this.refCount_;
    }

    synchronized Fqn getAndRemoveFirstFqnInList() {
        return (Fqn)this.referencingFqnList_.remove(0);
    }

    synchronized void addFqnIntoList(Fqn fqn) {
        this.referencingFqnList_.add(0, fqn);
    }
}

