/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.facelets;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletException;
import com.sun.facelets.el.VariableMapperWrapper;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagHandler;
import com.sun.facelets.tag.jsf.ComponentHandler;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.forms.layout.api.Layout;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutRow;
import org.nuxeo.ecm.platform.forms.layout.api.Widget;
import org.nuxeo.ecm.platform.forms.layout.facelets.FaceletHandlerHelper;
import org.nuxeo.ecm.platform.forms.layout.facelets.LeafFaceletHandler;
import org.nuxeo.ecm.platform.forms.layout.facelets.RenderVariables;
import org.nuxeo.ecm.platform.forms.layout.facelets.WidgetTagHandler;
import org.nuxeo.ecm.platform.forms.layout.service.WebLayoutManager;
import org.nuxeo.ecm.platform.ui.web.util.ComponentTagUtils;
import org.nuxeo.runtime.api.Framework;

public class LayoutTagHandler
extends TagHandler {
    private static final Log log = LogFactory.getLog(LayoutTagHandler.class);
    protected final TagConfig config;
    protected final TagAttribute name;
    protected final TagAttribute mode;
    protected final TagAttribute value;
    protected final TagAttribute template;
    protected final TagAttribute[] vars;
    protected final String[] reservedVarsArray = new String[]{"id", "name", "mode", "value", "template"};

    public LayoutTagHandler(TagConfig config) {
        super(config);
        this.config = config;
        this.name = this.getRequiredAttribute("name");
        this.mode = this.getRequiredAttribute("mode");
        this.value = this.getRequiredAttribute("value");
        this.template = this.getAttribute("template");
        this.vars = this.tag.getAttributes().getAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        WebLayoutManager layoutService;
        try {
            layoutService = (WebLayoutManager)Framework.getService(WebLayoutManager.class);
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
        String layoutName = this.name.getValue(ctx);
        String modeValue = this.mode.getValue(ctx);
        String valueName = this.value.getValue();
        if (ComponentTagUtils.isValueReference((String)valueName)) {
            valueName = valueName.substring(2, valueName.length() - 1);
        }
        VariableMapper orig = ctx.getVariableMapper();
        VariableMapperWrapper vm = new VariableMapperWrapper(orig);
        ctx.setVariableMapper((VariableMapper)vm);
        ValueExpression valueExpr = this.value.getValueExpression(ctx, Object.class);
        vm.setVariable(RenderVariables.globalVariables.value.name(), valueExpr);
        vm.setVariable(RenderVariables.globalVariables.document.name(), valueExpr);
        vm.setVariable(RenderVariables.globalVariables.layoutValue.name(), valueExpr);
        ExpressionFactory eFactory = ctx.getExpressionFactory();
        ValueExpression modeVe = eFactory.createValueExpression((Object)modeValue, String.class);
        vm.setVariable(RenderVariables.globalVariables.layoutMode.name(), modeVe);
        vm.setVariable(RenderVariables.globalVariables.mode.name(), modeVe);
        FaceletHandlerHelper helper = new FaceletHandlerHelper(ctx, this.config);
        Layout layout = layoutService.getLayout(ctx, layoutName, modeValue, valueName);
        if (layout == null) {
            String errMsg = String.format("Layout '%s' not found", layoutName);
            log.error((Object)errMsg);
            LeafFaceletHandler leaf = new LeafFaceletHandler();
            TagAttribute valueAttr = helper.createAttribute("value", (Serializable)((Object)("<span style=\"color:red;font-weight:bold;\">ERROR: " + errMsg + "</span><br />")));
            TagAttribute escapeAttr = helper.createAttribute("escape", (Serializable)((Object)"false"));
            ComponentHandler output = helper.getHtmlComponentHandler(FaceletHandlerHelper.getTagAttributes(valueAttr, escapeAttr), leaf, "javax.faces.HtmlOutputText", null);
            output.apply(ctx, parent);
            return;
        }
        layout.setId(helper.generateLayoutId(layout.getName()));
        List<String> reservedVars = Arrays.asList(this.reservedVarsArray);
        for (TagAttribute var : this.vars) {
            String localName = var.getLocalName();
            if (reservedVars.contains(localName)) continue;
            layout.setProperty(localName, (Serializable)((Object)var.getValue()));
        }
        ValueExpression layoutVe = eFactory.createValueExpression((Object)layout, Layout.class);
        vm.setVariable(RenderVariables.layoutVariables.layout.name(), layoutVe);
        for (Map.Entry prop : layout.getProperties().entrySet()) {
            vm.setVariable(String.format("%s_%s", RenderVariables.layoutVariables.layoutProperty.name(), prop.getKey()), eFactory.createValueExpression(prop.getValue(), Serializable.class));
        }
        String templateValue = null;
        if (this.template != null) {
            templateValue = this.template.getValue(ctx);
        }
        if (templateValue == null || "".equals(templateValue)) {
            templateValue = layout.getTemplate();
        }
        try {
            if (templateValue != null && !"".equals(templateValue)) {
                ctx.includeFacelet(parent, templateValue);
            } else {
                log.error((Object)("Missing template property for layout " + layoutName + " => applying basic template"));
                for (LayoutRow row : layout.getRows()) {
                    for (Widget widget : row.getWidgets()) {
                        WidgetTagHandler.applyWidgetHandler(ctx, parent, this.config, widget, this.value, false);
                    }
                }
            }
        }
        finally {
            ctx.setVariableMapper(orig);
        }
    }
}

