/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.regression;

import com.hp.hpl.jena.rdf.model.Alt;
import com.hp.hpl.jena.rdf.model.Bag;
import com.hp.hpl.jena.rdf.model.Container;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Seq;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import com.hp.hpl.jena.regression.NewRegressionBase;
import com.hp.hpl.jena.regression.Regression;
import com.hp.hpl.jena.shared.InvalidPropertyURIException;
import com.hp.hpl.jena.shared.PropertyNotFoundException;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import junit.framework.TestSuite;

public class NewRegressionResources
extends NewRegressionBase {
    public NewRegressionResources(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(NewRegressionResources.class);
    }

    protected Model getModel() {
        return ModelFactory.createDefaultModel();
    }

    public void testCreateAnonResource() {
        Model m = this.getModel();
        Resource r = m.createResource();
        NewRegressionResources.assertTrue((boolean)r.isAnon());
        NewRegressionResources.assertNull((Object)r.getURI());
        NewRegressionResources.assertNull((Object)r.getNameSpace());
        NewRegressionResources.assertNull((Object)r.getLocalName());
    }

    public void testCreateAnonResourceWithNull() {
        Model m = this.getModel();
        Resource r = m.createResource((String)null);
        NewRegressionResources.assertTrue((boolean)r.isAnon());
        NewRegressionResources.assertNull((Object)r.getURI());
        NewRegressionResources.assertNull((Object)r.getNameSpace());
        NewRegressionResources.assertNull((Object)r.getLocalName());
    }

    public void testCreateNamedResource() {
        Model m = this.getModel();
        String uri = "http://aldabaran.hpl.hp.com/foo";
        NewRegressionResources.assertEquals((String)uri, (String)m.createResource(uri).getURI());
    }

    public void testCreateTypedAnonResource() {
        Model m = this.getModel();
        Resource r = m.createResource(RDF.Property);
        NewRegressionResources.assertTrue((boolean)r.isAnon());
        NewRegressionResources.assertTrue((boolean)m.contains(r, RDF.type, RDF.Property));
    }

    public void testCreateTypedNamedresource() {
        Model m = this.getModel();
        String uri = "http://aldabaran.hpl.hp.com/foo";
        Resource r = m.createResource(uri, RDF.Property);
        NewRegressionResources.assertEquals((String)uri, (String)r.getURI());
        NewRegressionResources.assertTrue((boolean)m.contains(r, RDF.type, RDF.Property));
    }

    public void testCreateAnonByFactory() {
        Model m = this.getModel();
        NewRegressionResources.assertTrue((boolean)m.createResource(new Regression.ResTestObjF()).isAnon());
    }

    public void testCreateResourceByFactory() {
        Model m = this.getModel();
        String uri = "http://aldabaran.hpl.hp.com/foo";
        NewRegressionResources.assertEquals((String)uri, (String)m.createResource(uri, new Regression.ResTestObjF()).getURI());
    }

    public void testCreateNullPropertyFails() {
        Model m = this.getModel();
        try {
            m.createProperty(null);
            NewRegressionResources.fail((String)"should not create null property");
        }
        catch (InvalidPropertyURIException e) {
            NewRegressionResources.pass();
        }
    }

    public void testCreatePropertyOneArg() {
        Model m = this.getModel();
        Property p = m.createProperty("abc/def");
        NewRegressionResources.assertEquals((String)"abc/", (String)p.getNameSpace());
        NewRegressionResources.assertEquals((String)"def", (String)p.getLocalName());
        NewRegressionResources.assertEquals((String)"abc/def", (String)p.getURI());
    }

    public void testCreatePropertyTwoArgs() {
        Model m = this.getModel();
        Property p = m.createProperty("abc/", "def");
        NewRegressionResources.assertEquals((String)"abc/", (String)p.getNameSpace());
        NewRegressionResources.assertEquals((String)"def", (String)p.getLocalName());
        NewRegressionResources.assertEquals((String)"abc/def", (String)p.getURI());
    }

    public void testCreatePropertyStrangeURI() {
        Model m = this.getModel();
        String uri = RDF.getURI() + "_345";
        Property p = m.createProperty(uri);
        NewRegressionResources.assertEquals((String)RDF.getURI(), (String)p.getNameSpace());
        NewRegressionResources.assertEquals((String)"_345", (String)p.getLocalName());
        NewRegressionResources.assertEquals((String)uri, (String)p.getURI());
    }

    public void testCreatePropertyStrangeURITwoArgs() {
        Model m = this.getModel();
        String local = "_345";
        Property p = m.createProperty(RDF.getURI(), local);
        NewRegressionResources.assertEquals((String)RDF.getURI(), (String)p.getNameSpace());
        NewRegressionResources.assertEquals((String)local, (String)p.getLocalName());
        NewRegressionResources.assertEquals((String)(RDF.getURI() + local), (String)p.getURI());
    }

    public void testEnhancedResources() {
        Model m = this.getModel();
        ResourceImpl r = new ResourceImpl((ModelCom)m);
        this.testResource(m, r, 0);
        this.testResource(m, m.createBag(), 1);
        this.testContainer(m, m.createBag(), m.createBag());
        this.testResource(m, m.createAlt(), 1);
        this.testContainer(m, m.createAlt(), m.createAlt());
        this.testResource(m, m.createSeq(), 1);
        this.testContainer(m, m.createSeq(), m.createSeq());
    }

    protected Set setOf(Object x) {
        HashSet<Object> result = new HashSet<Object>();
        result.add(x);
        return result;
    }

    public void testResource(Model m, Resource r, int numProps) {
        Literal tvLiteral = m.createLiteral("test 12 string 2");
        Resource tvResource = m.createResource();
        String lang = "fr";
        NewRegressionResources.assertTrue((boolean)r.addProperty(RDF.value, 1L).hasProperty(RDF.value, 1L));
        NewRegressionResources.assertTrue((boolean)r.addProperty(RDF.value, 2L).hasProperty(RDF.value, 2L));
        NewRegressionResources.assertTrue((boolean)r.addProperty(RDF.value, -1L).hasProperty(RDF.value, -1L));
        NewRegressionResources.assertTrue((boolean)r.addProperty(RDF.value, -2L).hasProperty(RDF.value, -2L));
        NewRegressionResources.assertTrue((boolean)r.addProperty(RDF.value, '!').hasProperty(RDF.value, '!'));
        NewRegressionResources.assertTrue((boolean)r.addProperty(RDF.value, 123.456f).hasProperty(RDF.value, 123.456f));
        NewRegressionResources.assertTrue((boolean)r.addProperty(RDF.value, -123.456).hasProperty(RDF.value, -123.456));
        NewRegressionResources.assertTrue((boolean)r.addProperty(RDF.value, "test 12 string").hasProperty(RDF.value, "test 12 string"));
        NewRegressionResources.assertTrue((boolean)r.addProperty(RDF.value, "test 12 string", lang).hasProperty(RDF.value, "test 12 string", lang));
        NewRegressionResources.assertTrue((boolean)r.addProperty(RDF.value, tvObject).hasProperty(RDF.value, tvObject));
        NewRegressionResources.assertTrue((boolean)r.addProperty(RDF.value, tvLiteral).hasProperty(RDF.value, tvLiteral));
        NewRegressionResources.assertTrue((boolean)r.addProperty(RDF.value, tvResource).hasProperty(RDF.value, tvResource));
        NewRegressionResources.assertTrue((boolean)((Object)r.getRequiredProperty(RDF.value).getSubject()).equals(r));
        Property p = m.createProperty("foo/", "bar");
        try {
            r.getRequiredProperty(p);
            NewRegressionResources.fail((String)"should detect missing property");
        }
        catch (PropertyNotFoundException e) {
            NewRegressionResources.pass();
        }
        NewRegressionResources.assertEquals((int)12, (int)NewRegressionResources.iteratorToSet((Iterator)r.listProperties(RDF.value)).size());
        NewRegressionResources.assertEquals((Object)this.setOf(r), (Object)NewRegressionResources.iteratorToSet((Iterator)r.listProperties(RDF.value).mapWith(Statement.Util.getSubject)));
        NewRegressionResources.assertEquals((int)0, (int)NewRegressionResources.iteratorToSet((Iterator)r.listProperties(p)).size());
        NewRegressionResources.assertEquals(new HashSet(), (Object)NewRegressionResources.iteratorToSet((Iterator)r.listProperties(p).mapWith(Statement.Util.getSubject)));
        NewRegressionResources.assertEquals((int)(12 + numProps), (int)NewRegressionResources.iteratorToSet((Iterator)r.listProperties()).size());
        NewRegressionResources.assertEquals((Object)this.setOf(r), (Object)NewRegressionResources.iteratorToSet((Iterator)r.listProperties().mapWith(Statement.Util.getSubject)));
        r.removeProperties();
        NewRegressionResources.assertEquals((long)0L, (long)m.query(new SimpleSelector(r, null, (RDFNode)null)).size());
    }

    public void testContainer(Model m, Container cont1, Container cont2) {
        Literal tvLiteral = m.createLiteral("test 12 string 2");
        Resource tvResObj = m.createResource(new Regression.ResTestObjF());
        Regression.LitTestObj tvLitObj = new Regression.LitTestObj(1234L);
        Bag tvBag = m.createBag();
        Alt tvAlt = m.createAlt();
        Seq tvSeq = m.createSeq();
        String lang = "en";
        NewRegressionResources.assertEquals((int)0, (int)cont1.size());
        NewRegressionResources.assertEquals((int)0, (int)cont2.size());
        NewRegressionResources.assertTrue((boolean)cont1.add(true).contains(true));
        NewRegressionResources.assertTrue((boolean)cont1.add(1L).contains(1L));
        NewRegressionResources.assertTrue((boolean)cont1.add(2L).contains(2L));
        NewRegressionResources.assertTrue((boolean)cont1.add(-1L).contains(-1L));
        NewRegressionResources.assertTrue((boolean)cont1.add(-2L).contains(-2L));
        NewRegressionResources.assertTrue((boolean)cont1.add(123.456f).contains(123.456f));
        NewRegressionResources.assertTrue((boolean)cont1.add(-123.456).contains(-123.456));
        NewRegressionResources.assertTrue((boolean)cont1.add('!').contains('!'));
        NewRegressionResources.assertTrue((boolean)cont1.add("test 12 string").contains("test 12 string"));
        NewRegressionResources.assertFalse((boolean)cont1.contains("test 12 string", lang));
        NewRegressionResources.assertTrue((boolean)cont1.add("test 12 string", lang).contains("test 12 string", lang));
        NewRegressionResources.assertTrue((boolean)cont1.add(tvLiteral).contains(tvLiteral));
        NewRegressionResources.assertTrue((boolean)cont1.add(tvResObj).contains(tvResObj));
        NewRegressionResources.assertTrue((boolean)cont1.add(tvLitObj).contains(tvLitObj));
        NewRegressionResources.assertEquals((int)13, (int)cont1.size());
        int num = 10;
        for (int i = 0; i < num; ++i) {
            cont2.add(i);
        }
        NewRegressionResources.assertEquals((int)num, (int)cont2.size());
        this.checkNumericContent(cont2, num);
        boolean[] found = new boolean[num];
        boolean[] retain = new boolean[]{true, true, true, false, false, false, false, false, true, true};
        this.retainOnlySpecified(cont2, num, retain);
        this.seeWhatsThere(cont2, found);
        for (int i = 0; i < num; ++i) {
            NewRegressionResources.assertEquals((String)(i + "th element of array"), (boolean)retain[i], (boolean)found[i]);
        }
    }

    protected void seeWhatsThere(Container cont2, boolean[] found) {
        NodeIterator nit = cont2.iterator();
        while (nit.hasNext()) {
            int v = ((Literal)nit.nextNode()).getInt();
            NewRegressionResources.assertFalse((boolean)found[v]);
            found[v] = true;
        }
    }

    protected void retainOnlySpecified(Container cont2, int num, boolean[] retain) {
        NodeIterator nit = cont2.iterator();
        for (int i = 0; i < num; ++i) {
            nit.nextNode();
            if (retain[i]) continue;
            nit.remove();
        }
        NewRegressionResources.assertFalse((boolean)nit.hasNext());
    }

    protected void checkNumericContent(Container cont2, int num) {
        NodeIterator nit = cont2.iterator();
        for (int i = 0; i < num; ++i) {
            NewRegressionResources.assertEquals((int)i, (int)((Literal)nit.nextNode()).getInt());
        }
        NewRegressionResources.assertFalse((boolean)nit.hasNext());
    }
}

