/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.versioning.facet;

import java.text.NumberFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.facet.VersioningDocument;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.utils.DocumentModelUtils;
import org.nuxeo.runtime.api.Framework;

public class VersioningDocumentAdapter
implements VersioningDocument {
    private static final Log log = LogFactory.getLog(VersioningDocumentAdapter.class);
    private DocumentModel doc;
    private final String majorVersionProperty;
    private final String minorVersionProperty;

    VersioningDocumentAdapter(DocumentModel doc, String propMajorVersion, String propMinorVersion) {
        this.doc = doc;
        this.majorVersionProperty = propMajorVersion;
        this.minorVersionProperty = propMinorVersion;
    }

    public Long getMajorVersion() throws DocumentException {
        return this.getValidVersionNumber(this.majorVersionProperty);
    }

    public Long getMinorVersion() throws DocumentException {
        return this.getValidVersionNumber(this.minorVersionProperty);
    }

    public void incrementMajor() throws DocumentException {
        long major = this.getMajorVersion();
        this.setMajorVersion(major + 1L);
        this.setMinorVersion(0L);
    }

    public void incrementMinor() throws DocumentException {
        long minor = this.getMinorVersion();
        this.setMinorVersion(minor + 1L);
    }

    public void incrementVersions() {
    }

    public void setMajorVersion(Long value) {
        try {
            this.doc.setProperty(DocumentModelUtils.getSchemaName((String)this.majorVersionProperty), DocumentModelUtils.getFieldName((String)this.majorVersionProperty), (Object)value);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public void setMinorVersion(Long value) {
        try {
            this.doc.setProperty(DocumentModelUtils.getSchemaName((String)this.minorVersionProperty), DocumentModelUtils.getFieldName((String)this.minorVersionProperty), (Object)value);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    private long getValidVersionNumber(String propName) throws DocumentException {
        Object propVal;
        try {
            propVal = this.doc.getProperty(DocumentModelUtils.getSchemaName((String)propName), DocumentModelUtils.getFieldName((String)propName));
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
        long ver = 0L;
        if (null == propVal) {
            log.warn((Object)("Versioning field not initialized (property: " + propName + ") for doc: " + this.doc.getId()));
        } else {
            if (!(propVal instanceof Long)) {
                throw new DocumentException("Property " + propName + " should be of type Long");
            }
            ver = (Long)propVal;
        }
        return ver;
    }

    public String getVersionAsString(int majorDigits, int minorDigits, char sep) throws DocumentException {
        StringBuilder buf = new StringBuilder();
        NumberFormat fmt = VersioningDocumentAdapter.getFmt(majorDigits);
        buf.append(fmt.format(this.getMajorVersion()));
        buf.append(sep);
        NumberFormat fmt2 = VersioningDocumentAdapter.getFmt(minorDigits);
        buf.append(fmt2.format(this.getMinorVersion()));
        return buf.toString();
    }

    private static NumberFormat getFmt(int digits) {
        NumberFormat fmt = NumberFormat.getInstance();
        fmt.setMaximumIntegerDigits(digits);
        fmt.setMinimumIntegerDigits(digits);
        fmt.setMaximumFractionDigits(0);
        return fmt;
    }

    public void refetchDoc() throws DocumentException {
        this.doc = VersioningDocumentAdapter.getDocumentModel(this.doc.getRef(), this.doc.getRepositoryName());
    }

    private static DocumentModel getDocumentModel(DocumentRef docRef, String repName) throws DocumentException {
        DocumentModel documentModel;
        block5: {
            CoreSession coreSession = null;
            try {
                RepositoryManager mgr = (RepositoryManager)Framework.getService(RepositoryManager.class);
                Repository repo = mgr.getRepository(repName);
                coreSession = repo.open();
                documentModel = coreSession.getDocument(docRef);
                if (coreSession == null) break block5;
            }
            catch (Exception e) {
                try {
                    throw new DocumentException("cannot retrieve document for ref: " + docRef, (Throwable)e);
                }
                catch (Throwable throwable) {
                    if (coreSession != null) {
                        CoreInstance.getInstance().close(coreSession);
                    }
                    throw throwable;
                }
            }
            CoreInstance.getInstance().close(coreSession);
        }
        return documentModel;
    }
}

