/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendering.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.rendering.RenderingContext;
import org.nuxeo.ecm.platform.rendering.RenderingEngine;
import org.nuxeo.ecm.platform.rendering.RenderingException;
import org.nuxeo.ecm.platform.rendering.RenderingResult;
import org.nuxeo.ecm.platform.rendering.RenderingService;
import org.nuxeo.ecm.platform.rendering.impl.RenderingEngineDescriptor;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderingServiceImpl
extends DefaultComponent
implements RenderingService {
    private static final Log log = LogFactory.getLog(RenderingServiceImpl.class);
    public static final String EP_RENDER_ENGINES = "engines";
    private final Map<String, RenderingEngine> engines = new HashMap<String, RenderingEngine>();

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("register: " + contribution + ", ep: " + extensionPoint));
        }
        if (extensionPoint.equals(EP_RENDER_ENGINES)) {
            RenderingEngineDescriptor desc = (RenderingEngineDescriptor)contribution;
            try {
                RenderingEngine engine = desc.newInstance();
                this.engines.put(desc.getFormat(), engine);
            }
            catch (Exception e) {
                log.error((Object)("Cannot register rendering engine for " + desc.getFormat()), (Throwable)e);
            }
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals(EP_RENDER_ENGINES)) {
            RenderingEngineDescriptor desc = (RenderingEngineDescriptor)contribution;
            this.engines.remove(desc.getFormat());
        }
    }

    @Override
    public RenderingEngine getEngine(String name) {
        return this.engines.get(name);
    }

    @Override
    public Collection<RenderingResult> process(RenderingContext renderingCtx) throws RenderingException {
        ArrayList<RenderingResult> ret = new ArrayList<RenderingResult>();
        for (RenderingEngine engine : this.engines.values()) {
            if (!renderingCtx.accept(engine)) continue;
            RenderingResult result = engine.process(renderingCtx);
            if (result != null) {
                ret.add(result);
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("rendering ignored by the engine " + engine.getFormatName()));
        }
        return ret;
    }

    @Override
    public void registerEngine(RenderingEngine engine) {
        RenderingEngine existing = this.engines.put(engine.getFormatName(), engine);
        if (existing != null) {
            log.debug((Object)("Replaced existing RenderingEngine " + engine.getFormatName()));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Registered RenderingEngine " + engine.getFormatName()));
        }
    }

    @Override
    public void unregisterEngine(String name) {
        this.engines.remove(name);
    }
}

