/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendering.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.nuxeo.ecm.platform.rendering.RenderingResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultRenderingResult
implements RenderingResult {
    private static final long serialVersionUID = 6570212240033856735L;
    protected final String formatName;

    protected DefaultRenderingResult(String formatName) {
        this.formatName = formatName;
    }

    @Override
    public String getFormatName() {
        return this.formatName;
    }

    @Override
    public abstract Object getOutcome();

    @Override
    public InputStream getStream() {
        Object outcome = this.getOutcome();
        if (outcome instanceof InputStream) {
            return (InputStream)outcome;
        }
        if (outcome instanceof byte[]) {
            return new ByteArrayInputStream((byte[])outcome);
        }
        if (outcome instanceof CharSequence) {
            return new ByteArrayInputStream(outcome.toString().getBytes());
        }
        return this.getAdapter(InputStream.class);
    }

    public <E> E getAdapter(Class<E> adapter) {
        Object outcome = this.getOutcome();
        if (adapter.isAssignableFrom(outcome.getClass())) {
            return adapter.cast(outcome);
        }
        return null;
    }
}

