/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.client;

import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.nuxeo.ecm.core.client.LoginHandler;
import org.nuxeo.runtime.api.Framework;

public class DefaultLoginHandler
implements LoginHandler {
    private LoginContext lc;
    private String username;
    private char[] password;

    public DefaultLoginHandler() {
    }

    public DefaultLoginHandler(String username, String password) {
        this(username, password == null ? new char[]{} : password.toCharArray());
    }

    public DefaultLoginHandler(String username, char[] password) {
        this.username = username;
        this.password = password;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(char[] password) {
        this.password = password;
    }

    public void setPassword(String password) {
        this.password = password.toCharArray();
    }

    public char[] getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public synchronized LoginContext getLoginContext() {
        return this.lc;
    }

    public synchronized LoginContext login() throws LoginException {
        this.lc = this.username == null ? Framework.login() : Framework.login((String)this.username, (Object)this.password);
        return this.lc;
    }

    public synchronized void logout() throws LoginException {
        if (this.lc != null) {
            this.lc.logout();
        }
    }

    public synchronized void retryLogin() throws LoginException {
        if (this.lc != null) {
            this.lc.logout();
        }
        this.login();
    }
}

