/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.url.nxdoc;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.util.Calendar;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.runtime.api.Framework;

public class PropertyURLConnection
extends URLConnection {
    protected CoreSession session;
    protected boolean shared;
    protected DocumentModel doc;
    protected Property property;

    public PropertyURLConnection(URL url) {
        super(url);
    }

    protected void doConnect(URL u) throws Exception {
        CoreSession session = null;
        String sid = u.getRef();
        if (sid != null) {
            session = CoreInstance.getInstance().getSession(sid);
        }
        if (session == null) {
            RepositoryManager mgr = (RepositoryManager)Framework.getService(RepositoryManager.class);
            Repository repo = mgr.getRepository(u.getHost());
            session = repo.open();
            this.shared = false;
        } else {
            this.shared = true;
        }
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        if (!this.useCaches) {
            // empty if block
        }
        if (this.ifModifiedSince != 0L) {
            // empty if block
        }
        try {
            this.doConnect(this.url);
            this.getDocument();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            IOException ee = new IOException("Failed to open document connection");
            ee.initCause(e);
            throw ee;
        }
        this.connected = true;
    }

    public long getLastModified() {
        try {
            this.connect();
            DocumentPart part = this.getDocument().getPart("dublincore");
            if (part != null) {
                Calendar cal = (Calendar)part.getValue("modified");
                return cal.getTimeInMillis();
            }
            return -1L;
        }
        catch (Exception e) {
            return -1L;
        }
    }

    protected InputStream getStream() throws IOException {
        this.connect();
        this.getDocument();
        try {
            Serializable value = this.property.getValue();
            if (value == null) {
                return new ByteArrayInputStream(new byte[0]);
            }
            if (value instanceof Blob) {
                return ((Blob)((Object)value)).getStream();
            }
            if (value instanceof InputStream) {
                return (InputStream)((Object)value);
            }
            return new ByteArrayInputStream(value.toString().getBytes());
        }
        catch (PropertyException e) {
            IOException ee = new IOException("Failed to open get property value: " + this.url);
            ee.initCause(e);
            throw ee;
        }
    }

    public InputStream getInputStream() throws IOException {
        if (!this.shared) {
            return new FilterInputStream(this.getStream()){

                public void close() throws IOException {
                    super.close();
                    CoreInstance.getInstance().close(PropertyURLConnection.this.session);
                    PropertyURLConnection.this.session = null;
                    PropertyURLConnection.this.connected = false;
                }
            };
        }
        return this.getStream();
    }

    protected DocumentModel getDocument() throws IOException {
        try {
            String path = this.url.getPath();
            int p = path.indexOf(47);
            if (p == -1) {
                throw new IOException("Invalid Document URL: no xpath specified: " + this.url);
            }
            String id = path.substring(0, p);
            String xpath = path.substring(p + 1);
            DocumentModel doc = this.session.getDocument(new IdRef(id));
            if (doc == null) {
                throw new FileNotFoundException("Nod document property was found for URL: " + this.url);
            }
            this.property = doc.getProperty(xpath);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            IOException ee = new IOException("Failed to open document connection: " + this.url);
            ee.initCause(e);
            throw ee;
        }
        return this.doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.shared && this.session != null) {
                CoreInstance.getInstance().close(this.session);
                this.session = null;
            }
        }
        finally {
            super.finalize();
        }
    }
}

