/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.repository.cache;

import java.util.Calendar;
import java.util.ConcurrentModificationException;
import java.util.Date;
import org.nuxeo.common.DirtyUpdateInvokeBridge;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.operation.ModificationSet;

public class DirtyUpdateChecker {
    public static void check(DocumentModel doc) {
        long modified;
        DirtyUpdateInvokeBridge.ThreadContext ctx = DirtyUpdateInvokeBridge.getThreadContext();
        if (ctx == null) {
            return;
        }
        try {
            Property modifiedProp = doc.getProperty("dc:modified");
            if (modifiedProp == null) {
                return;
            }
            Date modifiedDate = modifiedProp.getValue(Date.class);
            if (modifiedDate == null) {
                return;
            }
            modified = modifiedDate.getTime();
        }
        catch (Exception e) {
            throw new ClientRuntimeException("cannot fetch dc modified for doc " + doc, e);
        }
        long tag = ctx.tag;
        if (tag >= modified) {
            return;
        }
        long invoked = ctx.invoked;
        if (invoked <= modified) {
            return;
        }
        String message = String.format("%s is outdated : cache %s - op start %s - doc %s", doc.getId(), new Date(tag), new Date(invoked), new Date(modified));
        throw new ConcurrentModificationException(message);
    }

    public static Object earliestTag(Object tag1, Object tag2) {
        return (Long)tag1 > (Long)tag2 ? tag1 : tag2;
    }

    public static Object computeTag(String sessionId, ModificationSet modifs) {
        return Calendar.getInstance().getTimeInMillis();
    }
}

