/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.repository;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.repository.RepositoryInstance;
import org.nuxeo.ecm.core.api.repository.RepositoryInstanceHandler;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.ServiceGroup;
import org.nuxeo.runtime.api.ServiceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XObject(value="repository")
public class Repository
implements Serializable {
    private static final long serialVersionUID = -5884097487266847648L;
    @XNode(value="@repositoryUri")
    private String repositoryUri;
    @XNode(value="@name")
    private String name;
    @XNode(value="@group")
    private String group;
    @XNode(value="@label")
    private String label;
    @XNodeMap(value="property", key="@name", type=HashMap.class, componentType=String.class)
    private Map<String, String> properties;
    @XNode(value="@supportsTags")
    protected Boolean supportsTags = null;

    public Repository() {
    }

    public Repository(String name, String label) {
        this.name = name;
        this.label = label;
        this.properties = new HashMap<String, String>();
    }

    public Repository(String name) {
        this(name, name);
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public String getProperty(String name, String defValue) {
        String val = this.properties.get(name);
        if (val == null) {
            return defValue;
        }
        return val;
    }

    public String removeProperty(String name) {
        return this.properties.remove(name);
    }

    public String setProperty(String name, String value) {
        return this.properties.put(name, value);
    }

    public CoreSession open() throws Exception {
        return this.open(new HashMap<String, Serializable>());
    }

    protected CoreSession lookupSession() throws Exception {
        CoreSession session;
        if (this.group != null) {
            ServiceManager mgr = (ServiceManager)Framework.getLocalService(ServiceManager.class);
            ServiceGroup sg = mgr.getGroup(this.group);
            if (sg == null) {
                throw new ClientException("group '" + this.group + "' not defined");
            }
            session = (CoreSession)sg.getService(CoreSession.class, this.name);
        } else {
            session = (CoreSession)Framework.getService(CoreSession.class, (String)this.name);
        }
        return session;
    }

    public boolean supportsTags() throws Exception {
        if (this.supportsTags == null) {
            CoreSession unconnectedSession = this.lookupSession();
            this.supportsTags = unconnectedSession.supportsTags(this.name);
            unconnectedSession.destroy();
        }
        return this.supportsTags;
    }

    public CoreSession open(Map<String, Serializable> context) throws Exception {
        CoreSession session = this.lookupSession();
        if (this.repositoryUri == null) {
            this.repositoryUri = this.name;
        }
        String sid = session.connect(this.repositoryUri, context);
        CoreInstance.getInstance().registerSession(sid, session);
        return session;
    }

    public static void close(CoreSession session) {
        CoreInstance.getInstance().close(session);
    }

    public static RepositoryInstance newRepositoryInstance(Repository repository) {
        return new RepositoryInstanceHandler(repository).getProxy();
    }

    public RepositoryInstance newInstance() {
        return Repository.newRepositoryInstance(this);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(Repository.class.getSimpleName());
        buf.append(" {name=").append(this.name);
        buf.append(", label=").append(this.label);
        buf.append('}');
        return buf.toString();
    }

    public String getRepositoryUri() {
        return this.repositoryUri;
    }
}

