/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.operation;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.operation.Modification;
import org.nuxeo.ecm.core.api.operation.ModificationSet;
import org.nuxeo.ecm.core.api.operation.OperationHandler;
import org.nuxeo.ecm.core.api.operation.ProgressMonitor;
import org.nuxeo.ecm.core.api.operation.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Operation<T>
implements Serializable {
    private static final long serialVersionUID = -9191284967153046156L;
    private static final ThreadLocal<Operation<?>> operation = new ThreadLocal();
    public static final String START_EVENT = "commandStarted";
    public static final String TERMINATE_EVENT = "commandTerminated";
    public static final int NONE = 0;
    public static final int RUNNING = 1;
    public static final int TERMINATED = 2;
    public static final int INTERNAL = 4;
    public static final int URGENT = 8;
    public static final int ASYNC = 16;
    public static final int BLOCK_JMS = 32;
    public static final int KEYED_DATA = 64;
    public static final int BLOCK_CHILD_NOTIFICATIONS = 128;
    public static final int RESERVED = 256;
    public static final int USER_FLAGS = 0xFFFE00;
    protected final String name;
    protected int flags;
    protected Object data;
    protected Status status = Status.STATUS_OK;
    protected T result;
    private ModificationSet modifs;
    protected transient Operation<?> parent;
    protected transient CoreSession session;
    protected long startedTime;
    protected long endedTime;

    public static int USER_FLAG(int n) {
        return n << 16;
    }

    protected Operation(String name, int flags) {
        this.name = name;
        this.flags = flags;
    }

    protected Operation(String name) {
        this(name, 0);
    }

    public static Operation<?> getCurrent() {
        return operation.get();
    }

    public static Operation<?>[] getStack() {
        Operation<?> cmd = operation.get();
        if (cmd == null) {
            return new Operation[0];
        }
        if (cmd.parent == null) {
            return new Operation[]{cmd};
        }
        ArrayList cmds = new ArrayList();
        cmd.fillCommandStack(cmds);
        return cmds.toArray(new Operation[cmds.size()]);
    }

    public static Operation<?>[] printStack(PrintStream out) {
        Operation<?> cmd = operation.get();
        if (cmd == null) {
            return new Operation[0];
        }
        if (cmd.parent == null) {
            return new Operation[]{cmd};
        }
        ArrayList cmds = new ArrayList();
        cmd.fillCommandStack(cmds);
        return cmds.toArray(new Operation[cmds.size()]);
    }

    public final Status getStatus() {
        return this.status;
    }

    public final int getFlags() {
        return this.flags;
    }

    public final void setFlags(int flags) {
        this.flags |= flags;
    }

    public final void clearFlags(int flags) {
        this.flags &= ~flags;
    }

    public final boolean isRunning() {
        return (this.flags & 1) == 1;
    }

    public final boolean isTerminated() {
        return (this.flags & 2) == 2;
    }

    public final boolean isFlagSet(int flag) {
        return (this.flags & flag) == flag;
    }

    public final T getResult() {
        return this.result;
    }

    public final String getName() {
        return this.name;
    }

    public final Operation<?> getParent() {
        return this.parent;
    }

    public final CoreSession getSession() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T run(CoreSession session, OperationHandler handler, ProgressMonitor monitor) {
        if (this.isRunning()) {
            throw new IllegalStateException("Command was already executed");
        }
        this.session = session;
        this.result = null;
        this.start();
        boolean isNotificationEnabled = this.isNotificationEnabled();
        if (handler != null && isNotificationEnabled) {
            handler.startOperation(this);
        }
        if (monitor != null) {
            monitor.started(this);
        }
        try {
            this.result = this.doRun(monitor);
        }
        catch (Throwable t) {
            this.status = new Status(2, t);
        }
        finally {
            if (handler != null && isNotificationEnabled) {
                handler.endOperation(this);
            }
            this.end();
            if (monitor != null) {
                monitor.terminated(this);
            }
        }
        return this.result;
    }

    private boolean isNotificationEnabled() {
        while (this.parent != null) {
            if (this.parent.isFlagSet(128)) {
                return false;
            }
            this.parent = this.parent.parent;
        }
        return true;
    }

    private void start() {
        this.setFlags(1);
        this.parent = operation.get();
        this.startedTime = this.parent != null ? this.parent.startedTime : Calendar.getInstance().getTimeInMillis();
        operation.set(this);
    }

    private void end() {
        operation.set(this.parent);
        this.setFlags(2);
        this.endedTime = Calendar.getInstance().getTimeInMillis();
    }

    public Date getStartedDate() {
        return new Date(this.startedTime);
    }

    public Date getEndedDate() {
        return new Date(this.endedTime);
    }

    public long getDuration() {
        return this.endedTime - this.startedTime;
    }

    public boolean isStartedBefore(long time) {
        return this.startedTime <= time;
    }

    public List<Operation<?>> getCommandStack() {
        ArrayList cmds = new ArrayList();
        this.fillCommandStack(cmds);
        return cmds;
    }

    public void fillCommandStack(List<Operation<?>> cmds) {
        if (this.parent != null) {
            this.fillCommandStack(cmds);
        }
        cmds.add(this);
    }

    public void printCommandStack(PrintStream out) {
        if (this.parent != null) {
            this.parent.printCommandStack(out);
        }
        out.println(this.toString());
    }

    public String toString() {
        return this.name;
    }

    public void addModification(Modification modif) {
        if (this.modifs == null) {
            this.modifs = new ModificationSet();
            this.initModificationSet(this.modifs);
        }
        this.modifs.add(modif);
    }

    public void addModification(DocumentRef ref, int modifType) {
        if (this.modifs == null) {
            this.modifs = new ModificationSet();
            this.initModificationSet(this.modifs);
        }
        this.modifs.add(ref, modifType);
    }

    public ModificationSet getModifications() {
        if (this.modifs == null) {
            this.modifs = new ModificationSet();
            this.initModificationSet(this.modifs);
        }
        return this.modifs;
    }

    protected void initModificationSet(ModificationSet modifs) {
    }

    public abstract T doRun(ProgressMonitor var1) throws Exception;

    public Object getData() {
        return (this.flags & 0x40) != 0 ? ((Object[])this.data)[0] : this.data;
    }

    public Object getData(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Data Key must not be null");
        }
        if ((this.flags & 0x40) != 0) {
            Object[] table = (Object[])this.data;
            for (int i = 1; i < table.length; i += 2) {
                if (!key.equals(table[i])) continue;
                return table[i + 1];
            }
        }
        return null;
    }

    public void setData(Object value) {
        if ((this.flags & 0x40) != 0) {
            ((Object[])this.data)[0] = value;
        } else {
            this.data = value;
        }
    }

    public void setData(String key, Object value) {
        int index;
        if (key == null) {
            throw new IllegalArgumentException("Data Key must not be null");
        }
        Object[] table = null;
        if ((this.flags & 0x40) != 0) {
            table = (Object[])this.data;
            for (index = 1; index < table.length && !key.equals(table[index]); index += 2) {
            }
        }
        if (value != null) {
            if ((this.flags & 0x40) != 0) {
                if (index == table.length) {
                    Object[] newTable = new Object[table.length + 2];
                    System.arraycopy(table, 0, newTable, 0, table.length);
                    table = newTable;
                    this.data = newTable;
                }
            } else {
                table = new Object[3];
                table[0] = this.data;
                this.data = table;
                this.flags |= 0x40;
            }
            table[index] = key;
            table[index + 1] = value;
        } else if ((this.flags & 0x40) != 0 && index != table.length) {
            int length = table.length - 2;
            if (length == 1) {
                this.data = table[0];
                this.flags &= 0xFFFFFFBF;
            } else {
                Object[] newTable = new Object[length];
                System.arraycopy(table, 0, newTable, 0, index);
                System.arraycopy(table, index + 2, newTable, index, length - index);
                this.data = newTable;
            }
        }
    }
}

