/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.operation;

import java.io.Serializable;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.operation.ModificationSet;
import org.nuxeo.ecm.core.api.operation.OperationEvent;
import org.nuxeo.ecm.core.api.repository.cache.DirtyUpdateChecker;

public class DefaultOperationEvent
implements OperationEvent {
    private static final long serialVersionUID = 1L;
    public String id;
    public String sessionId;
    public String repository;
    public String userName;
    public ModificationSet modifications;
    public Object details;
    public Object dirtyUpdateTag;

    public DefaultOperationEvent() {
    }

    public DefaultOperationEvent(CoreSession session, String id, ModificationSet modifs) {
        this(session, id, modifs, null);
    }

    public DefaultOperationEvent(CoreSession session, String id, ModificationSet modifs, Serializable details) {
        this(session.getSessionId(), session.getRepositoryName(), session.getPrincipal().getName(), id, modifs, details);
    }

    public DefaultOperationEvent(String sessionId, String repositoryName, String principal, String id, ModificationSet modifs, Object details) {
        this.sessionId = sessionId;
        this.repository = repositoryName;
        this.userName = principal;
        this.id = id;
        this.modifications = modifs;
        this.details = details;
        this.dirtyUpdateTag = DirtyUpdateChecker.computeTag(sessionId, modifs);
    }

    public Object getDetails() {
        return this.details;
    }

    public String getId() {
        return this.id;
    }

    public ModificationSet getModifications() {
        return this.modifications;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getRepositoryName() {
        return this.repository;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Object getDirtyUpdateTag() {
        return this.dirtyUpdateTag;
    }
}

