/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.model.impl.osm.util;

import java.lang.reflect.Field;
import org.nuxeo.ecm.core.api.model.impl.osm.util.AccessException;
import org.nuxeo.ecm.core.api.model.impl.osm.util.MemberAccessor;
import org.nuxeo.ecm.core.api.model.impl.osm.util.ReadOnlyAccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldAccessor
implements MemberAccessor {
    private static final long serialVersionUID = 2870143167271942320L;
    private final Field field;
    private boolean readOnly = false;

    public FieldAccessor(Field field, boolean isReadOnly) {
        this.field = field;
        this.readOnly = isReadOnly;
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
    }

    public FieldAccessor(Field field) {
        this(field, false);
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public Object get(Object instance) throws AccessException {
        try {
            return this.field.get(instance);
        }
        catch (Exception e) {
            throw new AccessException("Failed to read field: " + this.field, e);
        }
    }

    @Override
    public void set(Object instance, Object value) throws AccessException {
        if (this.readOnly) {
            throw new ReadOnlyAccessException("Attempted to write on a read only field: " + this.field);
        }
        try {
            this.field.set(instance, value);
        }
        catch (Exception e) {
            throw new AccessException("Failed to write field: " + this.field, e);
        }
    }

    @Override
    public Class<?> getType() {
        return this.field.getType();
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.field.getDeclaringClass();
    }

    public Field getField() {
        return this.field;
    }
}

