/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.model.impl.osm;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.api.model.impl.MapProperty;
import org.nuxeo.ecm.core.api.model.impl.ScalarProperty;
import org.nuxeo.ecm.core.api.model.impl.osm.Adaptable;
import org.nuxeo.ecm.core.api.model.impl.osm.ObjectAdapter;
import org.nuxeo.ecm.core.api.model.impl.osm.ScalarMemberProperty;
import org.nuxeo.ecm.core.schema.types.Field;

public class ComplexMemberProperty
extends MapProperty
implements Adaptable {
    private static final long serialVersionUID = 1537310098432620929L;
    private static final Log log = LogFactory.getLog(ComplexMemberProperty.class);
    protected final ObjectAdapter adapter;

    public ComplexMemberProperty(ObjectAdapter adapter, Property parent, Field field) {
        super(parent, field);
        this.adapter = adapter;
    }

    public ComplexMemberProperty(ObjectAdapter adapter, Property parent, Field field, int flags) {
        super(parent, field, flags);
        this.adapter = adapter;
    }

    public ObjectAdapter getAdapter() {
        return this.adapter;
    }

    public boolean isContainer() {
        return false;
    }

    public void setValue(Object value) throws PropertyException {
        if (value instanceof Map) {
            this.getAdapter().setMap(this.getValue(), (Map)value);
            this.setIsModified();
        } else {
            super.setValue(value);
        }
    }

    public void init(Serializable value) throws PropertyException {
        if (value == null) {
            return;
        }
        if (value instanceof Map) {
            this.internalSetValue((Serializable)this.getAdapter().create((Map)((Object)value)));
        } else {
            this.internalSetValue(value);
        }
        this.removePhantomFlag();
    }

    public void internalSetValue(Serializable value) throws PropertyException {
        ObjectAdapter adapter = ((Adaptable)((Object)this.parent)).getAdapter();
        adapter.setValue(this.parent.getValue(), this.getName(), value);
    }

    public Serializable internalGetValue() throws PropertyException {
        ObjectAdapter adapter = ((Adaptable)((Object)this.parent)).getAdapter();
        return (Serializable)adapter.getValue(this.parent.getValue(), this.getName());
    }

    public Serializable getValueForWrite() throws PropertyException {
        return this.getValue();
    }

    protected Property internalGetChild(Field field) {
        try {
            ObjectAdapter subAdapter = this.getAdapter().getAdapter(field.getName().getPrefixedName());
            if (subAdapter == null) {
                return new ScalarMemberProperty(this, field, this.isPhantom() ? 16 : 0);
            }
            return new ComplexMemberProperty(subAdapter, this, field, this.isPhantom() ? 16 : 0);
        }
        catch (PropertyNotFoundException e) {
            log.error((Object)e);
            return null;
        }
    }

    protected Serializable getDefaultValue() {
        return this.getAdapter().getDefaultValue();
    }

    public boolean isSameAs(Property property) throws PropertyException {
        if (property == null) {
            return false;
        }
        ScalarProperty sp = (ScalarProperty)property;
        Serializable v1 = this.getValue();
        Serializable v2 = sp.getValue();
        if (v1 == null) {
            return v2 == null;
        }
        return v1.equals(v2);
    }
}

