/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.model.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyDiff;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.api.model.PropertyFactory;
import org.nuxeo.ecm.core.api.model.PropertyRuntimeException;
import org.nuxeo.ecm.core.api.model.PropertyVisitor;
import org.nuxeo.ecm.core.api.model.ValueExporter;
import org.nuxeo.ecm.core.api.model.impl.AbstractProperty;
import org.nuxeo.ecm.core.api.model.impl.ComplexProperty;
import org.nuxeo.ecm.core.api.model.impl.DefaultPropertyFactory;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentPartImpl
extends ComplexProperty
implements DocumentPart {
    private static final long serialVersionUID = -2959928612693829263L;
    protected transient Schema schema;
    protected transient PropertyFactory factory;

    public DocumentPartImpl(Schema schema, PropertyFactory factory) {
        super(null);
        this.schema = schema;
        this.factory = factory == null ? DefaultPropertyFactory.getInstance() : factory;
    }

    public DocumentPartImpl(Schema schema) {
        this(schema, null);
    }

    @Override
    public void internalSetValue(Serializable value) throws PropertyException {
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public String getName() {
        return this.schema.getName();
    }

    public Schema getType() {
        return this.schema;
    }

    @Override
    public Field getField() {
        throw new UnsupportedOperationException("Document parts are not bound to schema fields");
    }

    @Override
    public Path collectPath(Path path) {
        return path;
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            Map<String, Serializable> value = this.exportValues();
            DocumentPartImpl dp = new DocumentPartImpl(this.schema);
            dp.importValues(value);
            return dp;
        }
        catch (PropertyException e) {
            throw new PropertyRuntimeException("clone failed", e);
        }
    }

    @Override
    public Map<String, Serializable> exportValues() throws PropertyException {
        ValueExporter exporter = new ValueExporter();
        return exporter.run(this);
    }

    @Override
    public void importValues(Map<String, Serializable> values) throws PropertyException {
        this.init((Serializable)((Object)values));
    }

    @Override
    public void accept(PropertyVisitor visitor, Object arg) throws PropertyException {
        if ((arg = visitor.visit(this, arg)) != null) {
            this.visitChildren(visitor, arg);
        }
    }

    @Override
    public Property createProperty(Property parent, Field field) {
        return this.createProperty(parent, field, 0);
    }

    @Override
    public Property createProperty(Property parent, Field field, int flags) {
        return this.factory.createProperty(parent, field, flags);
    }

    @Override
    public PropertyDiff exportDiff() {
        return null;
    }

    @Override
    public void importDiff(PropertyDiff diff) {
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        try {
            this.deserialize(in);
        }
        catch (PropertyException e) {
            IOException ee = new IOException("failed to deserialize document part " + this.schema);
            ee.initCause(e);
            throw ee;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        try {
            this.serialize(out);
        }
        catch (PropertyException e) {
            IOException ee = new IOException("failed to serialize document part " + this.schema);
            ee.initCause(e);
            throw ee;
        }
    }

    public void serialize(ObjectOutputStream out) throws PropertyException, IOException {
        out.writeObject(this.schema.getName());
        if (this.factory == null || this.factory == DefaultPropertyFactory.getInstance()) {
            out.writeObject(null);
        } else if (this.factory != null) {
            out.writeObject(this.factory);
        }
        Collection<Property> props = this.getNonPhantomChildren();
        int size = props.size();
        out.writeInt(size);
        if (size > 0) {
            for (Property child : props) {
                DocumentPartImpl.serializeProperty(child, out);
            }
        }
    }

    private static void serializeProperty(Property prop, ObjectOutputStream out) throws PropertyException, IOException {
        AbstractProperty ap = (AbstractProperty)prop;
        out.writeObject(prop.getName());
        out.writeObject(ap.data);
        out.writeInt(ap.flags);
        if (!prop.isContainer()) {
            out.writeObject(prop.getValue());
            return;
        }
        Collection<Property> props = null;
        props = prop.isList() ? prop.getChildren() : ((ComplexProperty)prop).getNonPhantomChildren();
        int size = props.size();
        out.writeInt(size);
        if (size > 0) {
            for (Property child : props) {
                DocumentPartImpl.serializeProperty(child, out);
            }
        }
    }

    public void deserialize(ObjectInputStream in) throws ClassNotFoundException, IOException, PropertyException {
        String schemaName = (String)in.readObject();
        this.schema = ((SchemaManager)Framework.getLocalService(SchemaManager.class)).getSchema(schemaName);
        this.factory = (PropertyFactory)in.readObject();
        if (this.factory == null) {
            this.factory = DefaultPropertyFactory.getInstance();
        }
        this.deserializeChildren(this, in);
    }

    public void deserializeChildren(ListProperty parent, ObjectInputStream in) throws ClassNotFoundException, IOException, PropertyException {
        int size = in.readInt();
        if (size < 1) {
            return;
        }
        Field field = parent.getType().getField();
        for (int i = 0; i < size; ++i) {
            in.readObject();
            Object data = in.readObject();
            int flags = in.readInt();
            Property prop = this.createProperty(parent, field, flags);
            ((AbstractProperty)prop).data = data;
            if (!prop.isContainer()) {
                prop.init((Serializable)in.readObject());
            } else if (prop.isList()) {
                this.deserializeChildren((ListProperty)prop, in);
            } else {
                this.deserializeChildren((ComplexProperty)prop, in);
            }
            parent.children.add(prop);
        }
    }

    public void deserializeChildren(ComplexProperty parent, ObjectInputStream in) throws ClassNotFoundException, IOException, PropertyException {
        parent.children = new Hashtable<String, Property>();
        int size = in.readInt();
        if (size < 1) {
            return;
        }
        ComplexType type = parent.getType();
        for (int i = 0; i < size; ++i) {
            String name = (String)in.readObject();
            Object data = in.readObject();
            int flags = in.readInt();
            Property prop = this.createProperty(parent, type.getField(name), flags);
            ((AbstractProperty)prop).data = data;
            if (!prop.isContainer()) {
                prop.init((Serializable)in.readObject());
            } else if (prop.isList()) {
                this.deserializeChildren((ListProperty)prop, in);
            } else {
                this.deserializeChildren((ComplexProperty)prop, in);
            }
            parent.children.put(prop.getName(), prop);
        }
    }

    public boolean isSameAs(DocumentPart dp) {
        if (dp == null) {
            return false;
        }
        if (dp instanceof ComplexProperty) {
            return ((Object)this.getNonPhantomChildren()).equals(((ComplexProperty)((Object)dp)).getNonPhantomChildren());
        }
        return false;
    }
}

