/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.impl;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.impl.DocumentModelTreeNodeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentModelTreeNodeComparator
implements Comparator<DocumentModelTreeNodeImpl>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final Map<String, String> titles;

    public DocumentModelTreeNodeComparator(Map<String, String> titles) {
        this.titles = titles;
    }

    protected String getTitlePath(DocumentModelTreeNodeImpl node) {
        Path path = node.getDocument().getPath();
        String titlePath = "/";
        for (int i = 1; i <= path.segmentCount(); ++i) {
            String parentPath = path.uptoSegment(i).toString();
            titlePath = this.titles.containsKey(parentPath) ? titlePath + this.titles.get(parentPath) + "/" : titlePath + path.segment(i - 1) + "/";
        }
        return titlePath;
    }

    @Override
    public int compare(DocumentModelTreeNodeImpl node1, DocumentModelTreeNodeImpl node2) {
        String titlePath1 = this.getTitlePath(node1);
        String titlePath2 = this.getTitlePath(node2);
        return titlePath1.compareTo(titlePath2);
    }
}

