/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.rest;

import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.rest.DocumentHelper;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.IllegalParameterException;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebObject(type="Document")
@Produces(value={"text/html; charset=UTF-8"})
public class DocumentObject
extends DefaultObject {
    protected DocumentModel doc;

    public <A> A getAdapter(Class<A> adapter) {
        if (adapter == DocumentModel.class) {
            return adapter.cast(this.doc);
        }
        return (A)super.getAdapter(adapter);
    }

    public void initialize(Object ... args) {
        assert (args != null && args.length == 1);
        this.doc = (DocumentModel)args[0];
    }

    @GET
    public Object doGet() {
        return this.getView("index");
    }

    @GET
    @Path(value="@delete")
    public Response getDelete() {
        return this.doDelete();
    }

    @GET
    @Path(value="@search")
    public Object search() {
        String query = this.ctx.getRequest().getParameter("query");
        if (query == null) {
            String fullText = this.ctx.getRequest().getParameter("fullText");
            if (fullText == null) {
                throw new IllegalParameterException("Expecting a query or a fullText parameter");
            }
            String orderBy = this.ctx.getRequest().getParameter("orderBy");
            String orderClause = "";
            if (orderBy != null) {
                orderClause = " ORDER BY " + orderBy;
            }
            String path = this.doc.isFolder() ? this.doc.getPathAsString() : this.doc.getPath().removeLastSegments(1).toString();
            query = "SELECT * FROM Document WHERE (ecm:fulltext = \"" + fullText + "\") AND (ecm:isCheckedInVersion = 0) AND (ecm:path STARTSWITH \"" + path + "\")" + orderClause;
        }
        try {
            DocumentModelList docs = this.ctx.getCoreSession().query(query);
            return this.getView("search").arg("query", (Object)query).arg("result", (Object)docs);
        }
        catch (ClientException e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    @DELETE
    public Response doDelete() {
        try {
            CoreSession session = this.ctx.getCoreSession();
            session.removeDocument(this.doc.getRef());
            session.save();
        }
        catch (Exception e) {
            throw WebException.wrap((String)("Failed to delete document " + this.doc.getPathAsString()), (Throwable)e);
        }
        if (this.prev != null) {
            return this.redirect(this.prev.getPath());
        }
        return this.redirect(this.ctx.getBasePath());
    }

    @POST
    public Response doPost() {
        String name = this.ctx.getForm().getString("name");
        DocumentModel newDoc = DocumentHelper.createDocument(this.ctx, this.doc, name);
        return this.redirect(this.getPath() + '/' + newDoc.getName());
    }

    @PUT
    public Response doPut() {
        this.doc = DocumentHelper.updateDocument(this.ctx, this.doc);
        return this.redirect(this.getPath());
    }

    @POST
    @Path(value="@put")
    public Response getPut() {
        return this.doPut();
    }

    public Object doHead() {
        return null;
    }

    @Path(value="{path}")
    public Resource traverse(@PathParam(value="path") String path) {
        return this.newDocument(path);
    }

    public DocumentObject newDocument(String path) {
        try {
            PathRef pathRef = new PathRef(this.doc.getPath().append(path).toString());
            DocumentModel doc = this.ctx.getCoreSession().getDocument((DocumentRef)pathRef);
            return (DocumentObject)this.ctx.newObject(doc.getType(), new Object[]{doc});
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    public DocumentObject newDocument(DocumentRef ref) {
        try {
            DocumentModel doc = this.ctx.getCoreSession().getDocument(ref);
            return (DocumentObject)this.ctx.newObject(doc.getType(), new Object[]{doc});
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    public DocumentObject newDocument(DocumentModel doc) {
        try {
            return (DocumentObject)this.ctx.newObject(doc.getType(), new Object[]{doc});
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    public CoreSession getCoreSession() {
        return this.ctx.getCoreSession();
    }

    public DocumentModel getDocument() {
        return this.doc;
    }

    public String getTitle() {
        try {
            return this.doc.getTitle();
        }
        catch (ClientException e) {
            throw WebException.wrap((Throwable)e);
        }
    }
}

