/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.uidgen.service;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.uidgen.UIDGenerator;
import org.nuxeo.ecm.platform.uidgen.UIDSequencer;
import org.nuxeo.ecm.platform.uidgen.UIDSequencerFactory;
import org.nuxeo.ecm.platform.uidgen.service.UIDGeneratorDescriptor;
import org.nuxeo.runtime.RuntimeServiceException;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UIDGeneratorService
extends DefaultComponent {
    public static final String ID = "org.nuxeo.ecm.platform.uidgen.service.UIDGeneratorService";
    public static final String UID_GENERATORS_EXTENSION_POINT = "generators";
    public static final String EXTENSION_POINT_SEQUENCER_FACTORY = "sequencerFactory";
    private static final Log log = LogFactory.getLog(UIDGeneratorService.class);
    private UIDSequencerFactory sequencerFactory;
    private UIDSequencer sequencer;
    private final Map<String, UIDGenerator> generators = new HashMap<String, UIDGenerator>();

    public UIDGeneratorService() {
        log.debug((Object)"<init>");
    }

    public void registerExtension(Extension extension) throws Exception {
        log.debug((Object)"<registerExtension>");
        super.registerExtension(extension);
        String extPoint = extension.getExtensionPoint();
        if (UID_GENERATORS_EXTENSION_POINT.equals(extPoint)) {
            log.info((Object)"register contributions for extension point: generators");
            Object[] contribs = extension.getContributions();
            this.registerGenerators(extension, contribs);
        } else if (EXTENSION_POINT_SEQUENCER_FACTORY.equals(extPoint)) {
            log.info((Object)"register contributions for extension point: sequencerFactory");
            String className = null;
            Element el = extension.getElement();
            NodeList nl = el.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node node = nl.item(i);
                if (!node.getNodeName().equals("className")) continue;
                className = node.getTextContent();
                break;
            }
            log.info((Object)("Sequencer factory class: " + className));
            if (null == className) {
                throw new RuntimeServiceException("Sequencer class not defined.");
            }
            this.sequencerFactory = (UIDSequencerFactory)extension.getContext().loadClass(className).newInstance();
        } else {
            log.warn((Object)("extension not handled: " + extPoint));
        }
    }

    private UIDSequencer getSequencer() {
        if (this.sequencer != null) {
            return this.sequencer;
        }
        this.sequencer = this.sequencerFactory.createUIDSequencer();
        log.info((Object)("Sequencer instantiated successfully: " + this.sequencer));
        return this.sequencer;
    }

    private void registerGenerators(Extension extension, Object[] contribs) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        for (Object contrib : contribs) {
            UIDGeneratorDescriptor generatorDescriptor = (UIDGeneratorDescriptor)contrib;
            String generatorName = generatorDescriptor.getName();
            UIDGenerator generator = (UIDGenerator)extension.getContext().loadClass(generatorDescriptor.getClassName()).newInstance();
            String[] propNames = generatorDescriptor.getPropertyNames();
            if (propNames.length == 0) {
                log.error((Object)("no property name defined on generator " + generatorName));
            }
            generator.setPropertyNames(propNames);
            String[] docTypes = generatorDescriptor.getDocTypes();
            this.registerGeneratorForDocTypes(generator, docTypes);
            log.info((Object)("registered UID generator: " + generatorName));
        }
    }

    private void registerGeneratorForDocTypes(UIDGenerator generator, String[] docTypes) {
        for (String docType : docTypes) {
            UIDGenerator previous = this.generators.put(docType, generator);
            if (previous != null) {
                log.info((Object)("Overwriting generator: " + previous.getClass() + " for docType: " + docType));
            }
            log.info((Object)("Registered generator: " + generator.getClass() + " for docType: " + docType));
        }
    }

    public void unregisterExtension(Extension extension) throws Exception {
        log.debug((Object)"<unregisterExtension>");
        super.unregisterExtension(extension);
    }

    public void deactivate(ComponentContext context) throws Exception {
        log.debug((Object)"<deactivate>");
        super.deactivate(context);
    }

    public UIDGenerator getUIDGeneratorFor(DocumentModel doc) {
        String docTypeName = doc.getType();
        UIDGenerator generator = this.generators.get(docTypeName);
        if (generator == null) {
            log.debug((Object)("No UID Generator defined for doc type: " + docTypeName));
            return null;
        }
        generator.setSequencer(this.getSequencer());
        return generator;
    }

    public void setUID(DocumentModel doc) throws DocumentException {
        UIDGenerator generator = this.getUIDGeneratorFor(doc);
        if (generator != null) {
            generator.setUID(doc);
        }
    }

    public String createUID(DocumentModel doc) throws DocumentException {
        UIDGenerator generator = this.getUIDGeneratorFor(doc);
        if (generator == null) {
            return null;
        }
        return generator.createUID(doc);
    }
}

