/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.uidgen.service;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XObject(value="generator")
public class UIDGeneratorDescriptor {
    private static final Log log = LogFactory.getLog(UIDGeneratorDescriptor.class);
    private static final int DEFAULT_COUNTER_START = 1;
    private String generationExpression;
    private Set<?> generationCriteria;
    private int counterStart;
    @XNode(value="@name")
    private String name;
    @XNode(value="@class")
    private String className;
    @XNodeList(value="propertyName", type=String[].class, componentType=String.class)
    private String[] propertyNames;
    @XNodeList(value="docType", type=String[].class, componentType=String.class)
    private String[] docTypes;

    public UIDGeneratorDescriptor() {
        log.debug((Object)"<UIDGeneratorDescriptor:init>");
    }

    public UIDGeneratorDescriptor(String generationExp, Set<?> generationCrit) {
        this(generationExp, generationCrit, 1);
    }

    public UIDGeneratorDescriptor(String generationExp, Set<?> generationCrit, int counterStart) {
        this.generationExpression = generationExp;
        this.generationCriteria = generationCrit;
        this.counterStart = counterStart;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String[] getDocTypes() {
        return this.docTypes;
    }

    public void setDocTypes(String[] docTypes) {
        this.docTypes = docTypes;
    }

    public int getCounterStart() {
        return this.counterStart;
    }

    public Set<?> getGenerationCriteria() {
        return this.generationCriteria;
    }

    public String getGenerationExpression() {
        return this.generationExpression;
    }

    public String getPropertyName() {
        if (this.propertyNames.length == 0) {
            log.warn((Object)"No propertyName specified");
            return null;
        }
        return this.propertyNames[0];
    }

    public void setPropertyName(String propertyName) {
        if (this.propertyNames.length == 0) {
            log.warn((Object)"Cannot set propertyName.");
        }
        this.propertyNames[0] = propertyName;
    }

    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    public void setPropertyNames(String[] propNames) {
        this.propertyNames = propNames;
    }
}

