/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.uidgen.ejb;

import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.uidgen.ejb.UIDSequenceBean;
import org.nuxeo.ecm.platform.uidgen.ejb.UIDSequencerManager;

@Stateless
@Local(value={UIDSequencerManager.class})
@Remote(value={UIDSequencerManager.class})
public class UIDSequencerManagerBean
implements UIDSequencerManager {
    public static final String RemoteJNDIName = "nuxeo/" + UIDSequencerManagerBean.class.getSimpleName() + "/remote";
    public static final String LocalJNDIName = "nuxeo/" + UIDSequencerManagerBean.class.getSimpleName() + "/local";
    private static final Log log = LogFactory.getLog(UIDSequencerManagerBean.class);
    @PersistenceContext(unitName="NXUIDSequencer")
    private EntityManager em;

    protected UIDSequenceBean doGetOrCreateSeq(String key) {
        UIDSequenceBean sequence;
        Query q = this.em.createNamedQuery("UIDSequence.findByKey");
        q.setParameter("key", (Object)key);
        try {
            sequence = (UIDSequenceBean)q.getSingleResult();
        }
        catch (NoResultException e) {
            sequence = new UIDSequenceBean(key);
            this.em.persist((Object)sequence);
            log.debug((Object)("created seq " + key));
        }
        return sequence;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public int getNext(String key) {
        return this.doGetOrCreateSeq(key).nextIndex();
    }
}

