/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.io.client;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.io.DocumentReader;
import org.nuxeo.ecm.core.io.DocumentWriter;
import org.nuxeo.ecm.core.io.impl.DocumentPipeImpl;
import org.nuxeo.ecm.core.io.impl.plugins.NuxeoArchiveWriter;
import org.nuxeo.ecm.platform.io.selectionReader.DocumentModelListReader;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.util.BaseURL;
import org.nuxeo.ecm.webapp.clipboard.ClipboardActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="importExportAction")
@Scope(value=ScopeType.EVENT)
public class ImportExportActionBean
implements Serializable {
    private static final String RESTLET_PREFIX = "restAPI";
    private static final Log log = LogFactory.getLog(ImportExportActionBean.class);
    private static final long serialVersionUID = 1770386525984671333L;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true)
    protected transient ClipboardActions clipboardActions;

    private static StringBuffer getRestletBaseURL(DocumentModel doc) {
        StringBuffer urlb = new StringBuffer();
        urlb.append(BaseURL.getBaseURL());
        urlb.append(RESTLET_PREFIX);
        urlb.append('/');
        urlb.append(doc.getRepositoryName());
        urlb.append('/');
        urlb.append(doc.getRef().toString());
        urlb.append('/');
        return urlb;
    }

    private static HttpServletResponse getHttpServletResponse() {
        ServletResponse response = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null) {
            response = (ServletResponse)facesContext.getExternalContext().getResponse();
        }
        if (response != null && response instanceof HttpServletResponse) {
            return (HttpServletResponse)response;
        }
        return null;
    }

    private static HttpServletRequest getHttpServletRequest() {
        ServletRequest request = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null) {
            request = (ServletRequest)facesContext.getExternalContext().getRequest();
        }
        if (request != null && request instanceof HttpServletRequest) {
            return (HttpServletRequest)request;
        }
        return null;
    }

    private static void handleRedirect(HttpServletResponse response, String url) throws IOException {
        response.resetBuffer();
        response.sendRedirect(url);
        response.flushBuffer();
        ImportExportActionBean.getHttpServletRequest().setAttribute("nuxeo.disable.redirect.wrapper", (Object)true);
        FacesContext.getCurrentInstance().responseComplete();
    }

    public String doExportDocument() throws IOException {
        HttpServletResponse response = ImportExportActionBean.getHttpServletResponse();
        if (response != null) {
            ImportExportActionBean.handleRedirect(response, this.getDocumentExportURL());
        }
        return null;
    }

    public String doExportFolder() throws IOException {
        HttpServletResponse response = ImportExportActionBean.getHttpServletResponse();
        if (response != null) {
            ImportExportActionBean.handleRedirect(response, this.getFolderExportURL());
        }
        return null;
    }

    public String getDocumentExportURL() {
        StringBuffer urlb = ImportExportActionBean.getRestletBaseURL(this.navigationContext.getCurrentDocument());
        urlb.append("exportTree?format=XML");
        return urlb.toString();
    }

    public String getFolderExportURL() {
        StringBuffer urlb = ImportExportActionBean.getRestletBaseURL(this.navigationContext.getCurrentDocument());
        urlb.append("exportTree?format=ZIP");
        return urlb.toString();
    }

    public String exportCurrentList() {
        List docList = this.clipboardActions.getCurrentSelectedList();
        if (docList != null) {
            ImportExportActionBean.export(docList);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void export(List<DocumentModel> docList) {
        HttpServletResponse response = ImportExportActionBean.getHttpServletResponse();
        if (response == null) {
            return;
        }
        DocumentModelListReader reader = null;
        NuxeoArchiveWriter writer = null;
        try {
            reader = new DocumentModelListReader(docList);
            response.reset();
            writer = new NuxeoArchiveWriter((OutputStream)response.getOutputStream());
            DocumentPipeImpl pipe = new DocumentPipeImpl(10);
            pipe.setReader((DocumentReader)reader);
            pipe.setWriter((DocumentWriter)writer);
            pipe.run();
            String filename = "export.zip";
            response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\";");
            response.setHeader("Content-Type", "application/zip");
            FacesContext.getCurrentInstance().responseComplete();
        }
        catch (ClientException e) {
            log.error((Object)("Error during XML export " + e.getMessage()));
        }
        catch (IOException e) {
            log.error((Object)("Error during XML export " + e.getMessage()));
        }
        catch (Exception e) {
            log.error((Object)("Error during XML export " + e.getMessage()));
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }
}

