/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.webcontainer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.webapp.webcontainer.ThemeActions;
import org.nuxeo.theme.ApplicationType;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.NegotiationDef;
import org.nuxeo.theme.themes.ThemeManager;
import org.nuxeo.theme.types.TypeFamily;
import org.nuxeo.theme.types.TypeRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="WebcontainerThemeActions")
@Scope(value=ScopeType.PAGE)
public class ThemeActionsBean
implements ThemeActions,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ThemeActionsBean.class);
    @In(create=true, required=false)
    protected transient CoreSession documentManager;

    @Override
    public List<SelectItem> getAvailableThemes() {
        ArrayList<SelectItem> themes = new ArrayList<SelectItem>();
        Manager.getThemeManager();
        for (String theme : ThemeManager.getThemeNames()) {
            themes.add(new SelectItem((Object)theme, theme));
        }
        return themes;
    }

    @Override
    public List<SelectItem> getAvailablePages(String theme) {
        ArrayList<SelectItem> pages = new ArrayList<SelectItem>();
        if (theme != null && !theme.equals("")) {
            for (String pageName : Manager.getThemeManager().getPageNames(theme)) {
                pages.add(new SelectItem((Object)pageName, pageName));
            }
        }
        return pages;
    }

    @Override
    public String getDefaultTheme() {
        FacesContext fContext = FacesContext.getCurrentInstance();
        TypeRegistry typeRegistry = Manager.getTypeRegistry();
        ExternalContext external = fContext.getExternalContext();
        ApplicationType app = (ApplicationType)typeRegistry.lookup(TypeFamily.APPLICATION, external.getRequestContextPath());
        NegotiationDef negotiation = app.getNegotiation();
        return negotiation.getDefaultTheme();
    }
}

