/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.shield;

import java.io.IOException;
import javax.faces.application.Application;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.Seam;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.FacesLifecycle;
import org.jboss.seam.core.ConversationPropagation;
import org.jboss.seam.core.Manager;
import org.jboss.seam.mock.MockApplication;
import org.jboss.seam.mock.MockExternalContext;
import org.jboss.seam.mock.MockFacesContext;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.service.NullExceptionHandlingListener;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class SeamExceptionHandlingListener
extends NullExceptionHandlingListener {
    private static final Log log = LogFactory.getLog(SeamExceptionHandlingListener.class);

    public void beforeSetErrorPageAttribute(Throwable t, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            MockFacesContext mockContext = this.createFacesContext(request, response);
            mockContext.setCurrent();
            facesContext = mockContext;
            log.debug((Object)"Created mock faces context for exception handling");
        } else {
            log.debug((Object)"Using existing faces context for exception handling");
        }
        Manager manager = Contexts.isEventContextActive() ? (Manager)Contexts.getEventContext().get(Manager.class) : (Manager)request.getAttribute(Seam.getComponentName(Manager.class));
        String conversationId = manager == null ? null : manager.getCurrentConversationId();
        FacesLifecycle.beginExceptionRecovery((ExternalContext)facesContext.getExternalContext());
        if (conversationId == null) {
            Manager.instance().initializeTemporaryConversation();
        } else {
            ConversationPropagation.instance().setConversationId(conversationId);
            Manager.instance().restoreConversation();
        }
    }

    public void startHandling(Throwable t, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        if (TransactionHelper.isTransactionActive()) {
            TransactionHelper.setTransactionRollbackOnly();
        }
    }

    public void afterDispatch(Throwable t, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context instanceof MockFacesContext) {
            FacesLifecycle.endRequest((ExternalContext)context.getExternalContext());
            context.release();
        }
    }

    protected MockFacesContext createFacesContext(HttpServletRequest request, HttpServletResponse response) {
        MockFacesContext mockFacesContext = new MockFacesContext((ExternalContext)new MockExternalContext(request.getSession().getServletContext(), request, response), (Application)new MockApplication());
        mockFacesContext.setViewRoot(new UIViewRoot());
        return mockFacesContext;
    }
}

