/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.search;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.search.api.client.querymodel.descriptor.FieldDescriptor;
import org.nuxeo.ecm.webapp.search.ConfigDescriptor;
import org.nuxeo.ecm.webapp.search.FieldGroupDescriptor;
import org.nuxeo.ecm.webapp.search.ResultColumnsDescriptor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchUIConfigService
extends DefaultComponent {
    public static final ComponentName NAME = new ComponentName(SearchUIConfigService.class.getName());
    private static final Log log = LogFactory.getLog(SearchUIConfigService.class);
    private Map<String, ConfigDescriptor> configMap;
    private Map<String, List<FieldDescriptor>> resultColumnsMap;
    public static final String AVAILABLE_SEARCH_COLUMNS = "availableSearchColumns";
    public static final String AVAILABLE_RESULT_COLUMNS = "availableResultColumns";

    public void activate(ComponentContext context) throws Exception {
        log.debug((Object)"<activate>");
        this.configMap = new HashMap<String, ConfigDescriptor>();
        this.resultColumnsMap = new HashMap<String, List<FieldDescriptor>>();
        super.activate(context);
    }

    public void deactivate(ComponentContext context) throws Exception {
        log.debug((Object)"<deactivate>");
        this.configMap = null;
        super.deactivate(context);
    }

    public void registerExtension(Extension extension) throws Exception {
        String extensionPoint = extension.getExtensionPoint();
        if (extensionPoint.equals("config")) {
            this.registerConfig(extension);
        } else if (extensionPoint.equals("resultColumns")) {
            this.registerResultColumnGroup(extension);
        } else {
            throw new Exception("unknown extension point: " + extensionPoint);
        }
    }

    public void registerConfig(Extension extension) {
        Object[] contribs;
        for (Object contrib : contribs = extension.getContributions()) {
            ConfigDescriptor config = (ConfigDescriptor)contrib;
            this.configMap.put(config.getName(), config);
            log.debug((Object)("registered service config: " + config.name));
        }
    }

    public void registerResultColumnGroup(Extension extension) {
        Object[] contribs;
        for (Object contrib : contribs = extension.getContributions()) {
            ResultColumnsDescriptor desc = (ResultColumnsDescriptor)contrib;
            this.resultColumnsMap.put(desc.getName(), desc.getFields());
            log.debug((Object)("registered column group: " + desc.getName()));
        }
    }

    public void unregisterExtension(Extension extension) throws Exception {
        Object[] contribs;
        for (Object contrib : contribs = extension.getContributions()) {
            Object config;
            if (extension.getExtensionPoint().equals("config")) {
                config = (ConfigDescriptor)contrib;
                this.configMap.put(((ConfigDescriptor)config).getName(), null);
                log.debug((Object)("unregistered service config: " + ((ConfigDescriptor)config).getName()));
                continue;
            }
            if (!extension.getExtensionPoint().equals("resultColumns")) continue;
            config = (ResultColumnsDescriptor)contrib;
            this.resultColumnsMap.put(((ResultColumnsDescriptor)config).getName(), null);
            log.debug((Object)("unregistered service config: " + ((ResultColumnsDescriptor)config).getName()));
        }
    }

    public List<FieldGroupDescriptor> getFieldGroups(String configName) {
        ConfigDescriptor config = this.configMap.get(configName);
        if (config == null) {
            log.error((Object)("unknown config name: " + configName));
            return null;
        }
        return config.getFieldGroups();
    }

    public List<FieldDescriptor> getResultColumns(String name) {
        return this.resultColumnsMap.get(name);
    }
}

