/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.edit.vocabularies;

import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.ejb.Remove;
import javax.faces.application.FacesMessage;
import javax.faces.event.ActionEvent;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.datamodel.DataModel;
import org.jboss.seam.annotations.datamodel.DataModelSelection;
import org.jboss.seam.faces.FacesMessages;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.SizeLimitExceededException;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.ui.web.directory.DirectoryHelper;
import org.nuxeo.ecm.platform.ui.web.directory.VocabularyEntry;
import org.nuxeo.ecm.webapp.edit.vocabularies.VocabularyActions;
import org.nuxeo.ecm.webapp.edit.vocabularies.VocabularyConstants;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="vocabularyActions")
@Scope(value=ScopeType.CONVERSATION)
@Deprecated
public class VocabularyActionsBean
implements VocabularyActions {
    private static final long serialVersionUID = -257772806500630093L;
    private static final Log log = LogFactory.getLog(VocabularyActionsBean.class);
    public static final String NULL_MARKER = "__NULL__";
    private boolean showAddEntryForm = false;
    private boolean editable = false;
    private String style;
    private String commandName1;
    private String commandName2;
    private VocabularyEntry searchCriteria;
    private String title;
    private transient DirectoryService dirService;
    private List<SelectItem> parentIds;
    @DataModel
    private List<String> vocabularyNames;
    @DataModelSelection(value="vocabularyNames")
    private String selectedVocabularyName;
    @DataModel
    private List<VocabularyEntry> selectedVocabularyEntries;
    @DataModelSelection(value="selectedVocabularyEntries")
    protected VocabularyEntry selectedVocabularyEntry;
    @In(create=true, required=false)
    protected transient FacesMessages facesMessages;
    @In(create=true)
    protected transient ResourcesAccessor resourcesAccessor;

    @Override
    @Begin(join=true)
    @Create
    public void initialize() {
        this.initDirService();
    }

    private void initDirService() {
        if (this.dirService == null) {
            this.dirService = DirectoryHelper.getDirectoryService();
            if (this.dirService == null) {
                log.error((Object)"Failed to lookup directory service");
            }
        }
    }

    @Factory(value="selectedVocabularyEntries")
    protected void selectedVocabularyEntriesFactory() throws ClientException {
        this.editVocabulary();
    }

    @Override
    public String editVocabulary() throws ClientException {
        this.showAddEntryForm = false;
        this.searchCriteria = this.getEmptyVocabularyEntry();
        return this.searchVocabularyEntries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String clearVocabulary() throws ClientException {
        Session vocabulary = null;
        String message = null;
        try {
            vocabulary = this.getCurrentVocabulary();
            if (vocabulary != null) {
                for (DocumentModel entry : vocabulary.getEntries()) {
                    vocabulary.deleteEntry(entry.getId());
                }
                vocabulary.commit();
                message = "vocabulary.cleared";
            }
        }
        finally {
            if (vocabulary != null) {
                vocabulary.close();
            }
        }
        this.facesMessages.add(FacesMessage.SEVERITY_INFO, (String)this.resourcesAccessor.getMessages().get(message), new Object[0]);
        this.showAddEntryForm = false;
        return "view_vocabularies";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String addVocabularyEntry() throws ClientException {
        Session vocabulary = null;
        String message = "vocabulary.entry.added";
        try {
            vocabulary = this.getCurrentVocabulary();
            if (vocabulary != null) {
                if ("command.edit".equals(this.commandName1)) {
                    if (this.isHierarchical()) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("parent", this.selectedVocabularyEntry.getParent());
                        vocabulary.deleteEntry(this.selectedVocabularyEntry.getId(), map);
                    } else {
                        vocabulary.deleteEntry(this.selectedVocabularyEntry.getId());
                    }
                    vocabulary.commit();
                    message = "vocabulary.entry.edited";
                }
                HashMap<String, String> filter = new HashMap<String, String>();
                filter.put("id", this.selectedVocabularyEntry.getId());
                if (this.isHierarchical()) {
                    filter.put("parent", this.selectedVocabularyEntry.getParent());
                }
                if (!vocabulary.query(filter).isEmpty()) {
                    this.facesMessages.addToControl("id", FacesMessage.SEVERITY_INFO, (String)this.resourcesAccessor.getMessages().get("vocabulary.entry.identifier.already.exists"), new Object[0]);
                    String string = "view_vocabulary";
                    return string;
                }
                HashMap<String, Object> values = new HashMap<String, Object>();
                values.put("id", this.selectedVocabularyEntry.getId());
                values.put("label", this.selectedVocabularyEntry.getLabel());
                values.put("obsolete", Boolean.TRUE.equals(this.selectedVocabularyEntry.getObsolete()) ? 1L : (long)VocabularyConstants.DEFAULT_OBSOLETE.intValue());
                if (this.isHierarchical()) {
                    String parent = this.selectedVocabularyEntry.getParent();
                    if ("".equals(parent)) {
                        parent = null;
                    }
                    values.put("parent", parent);
                }
                values.put("ordering", this.selectedVocabularyEntry.getOrdering() != null ? this.selectedVocabularyEntry.getOrdering() : VocabularyConstants.DEFAULT_VOCABULARY_ORDER);
                vocabulary.createEntry(values);
                vocabulary.commit();
            } else {
                message = "";
            }
        }
        catch (UnsupportedOperationException e) {
            message = "vocabulary.entry.not.added";
        }
        finally {
            if (vocabulary != null) {
                vocabulary.close();
            }
        }
        this.facesMessages.add(FacesMessage.SEVERITY_INFO, (String)this.resourcesAccessor.getMessages().get(message), new Object[0]);
        this.showAddEntryForm = false;
        return this.editVocabulary();
    }

    @Override
    public String editVocabularyEntry() {
        this.editable = true;
        this.showAddEntryForm = true;
        this.commandName1 = "command.edit";
        this.commandName2 = "command.cancel";
        this.style = "none";
        return "view_vocabulary";
    }

    @Override
    public String viewVocabularyEntry() {
        this.editable = false;
        this.showAddEntryForm = true;
        this.commandName2 = "command.ok";
        this.style = "notEditable";
        return "view_vocabulary";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String deleteVocabularyEntry() throws ClientException {
        Session vocabulary = null;
        String message = null;
        try {
            vocabulary = this.getCurrentVocabulary();
            if (vocabulary != null) {
                if (this.isHierarchical()) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("parent", this.selectedVocabularyEntry.getParent());
                    vocabulary.deleteEntry(this.selectedVocabularyEntry.getId(), map);
                } else {
                    vocabulary.deleteEntry(this.selectedVocabularyEntry.getId());
                }
                vocabulary.commit();
                message = "vocabulary.entry.deleted";
            }
        }
        catch (UnsupportedOperationException e) {
            message = "vocabulary.entry.not.deleted";
        }
        finally {
            if (vocabulary != null) {
                vocabulary.close();
            }
        }
        this.facesMessages.add(FacesMessage.SEVERITY_INFO, (String)this.resourcesAccessor.getMessages().get(message), new Object[0]);
        this.showAddEntryForm = false;
        return this.editVocabulary();
    }

    @Factory(value="vocabularyNames")
    protected void vocabularyNamesFactory() throws ClientException {
        this.viewAllVocabularies();
    }

    @Override
    public String viewAllVocabularies() throws ClientException {
        this.vocabularyNames = new ArrayList<String>();
        for (String dirName : this.dirService.getDirectoryNames()) {
            String schema = this.dirService.getDirectorySchema(dirName);
            if (!"vocabulary".equals(schema) && !"xvocabulary".equals(schema)) continue;
            this.vocabularyNames.add(dirName);
        }
        Collections.sort(this.vocabularyNames, VocabularyComparator.INSTANCE);
        return "view_vocabularies";
    }

    @Override
    public String getSelectedVocabularyName() {
        return this.selectedVocabularyName;
    }

    @Override
    public void setSelectedVocabularyName(String selectedVocabularyName) {
        this.selectedVocabularyName = selectedVocabularyName;
    }

    @Override
    public VocabularyEntry getSelectedVocabularyEntry() {
        return this.selectedVocabularyEntry;
    }

    @Override
    public void setSelectedVocabularyEntry(VocabularyEntry entry) {
        this.selectedVocabularyEntry = entry;
    }

    @Override
    public void toggleAddEntryForm(ActionEvent event) {
        if (this.showAddEntryForm) {
            this.showAddEntryForm = false;
        } else {
            try {
                this.selectedVocabularyEntry = this.getEmptyVocabularyEntry();
            }
            catch (ClientException e) {
                log.debug((Object)"there was an error while instantiating a new vocabulary entry ", (Throwable)e);
            }
            this.showAddEntryForm = true;
            this.editable = true;
            this.commandName1 = "command.add";
            this.commandName2 = "command.cancel";
            this.style = "none";
        }
    }

    @Override
    public boolean getShowAddEntryForm() {
        return this.showAddEntryForm;
    }

    public void setShowAddEntryForm(boolean showAddEntryForm) {
        this.showAddEntryForm = showAddEntryForm;
    }

    @Override
    public boolean getEditable() {
        return this.editable;
    }

    @Override
    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @Override
    public String getCommandName1() {
        return this.commandName1;
    }

    @Override
    public void setCommandName1(String commandName) {
        this.commandName1 = commandName;
    }

    @Override
    public String getCommandName2() {
        return this.commandName2;
    }

    @Override
    public void setCommandName2(String commandName) {
        this.commandName2 = commandName;
    }

    @Override
    public String getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(String style) {
        this.style = style;
    }

    @Override
    public String cancel() {
        log.debug((Object)"cancel adding/editing vocabulary entry ...");
        this.selectedVocabularyEntry = null;
        this.showAddEntryForm = false;
        return "view_vocabulary";
    }

    private VocabularyEntry getVocabularyEntry(DocumentModel vocabularyEntry) throws DirectoryException {
        Integer ordering;
        VocabularyEntry result;
        String schemaName = this.dirService.getDirectorySchema(this.selectedVocabularyName);
        try {
            result = new VocabularyEntry((String)vocabularyEntry.getProperty(schemaName, "id"), (String)vocabularyEntry.getProperty(schemaName, "label"));
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
        try {
            result.setObsolete(((Long)vocabularyEntry.getProperty(schemaName, "obsolete")).intValue() == 0 ? Boolean.FALSE : Boolean.TRUE);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
        try {
            ordering = ((Long)vocabularyEntry.getProperty(schemaName, "ordering")).intValue();
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
        result.setOrdering(ordering.equals(VocabularyConstants.DEFAULT_VOCABULARY_ORDER) ? null : ordering);
        if (this.isHierarchical()) {
            try {
                result.setParent((String)vocabularyEntry.getProperty(schemaName, "parent"));
            }
            catch (ClientException e) {
                throw new ClientRuntimeException((Throwable)e);
            }
        }
        return result;
    }

    private Session getCurrentVocabulary() throws ClientException {
        return this.dirService.open(this.selectedVocabularyName);
    }

    @Override
    public VocabularyEntry getSearchCriteria() {
        return this.searchCriteria;
    }

    @Override
    public void setSearchCriteria(VocabularyEntry searchCriteria) {
        this.searchCriteria = searchCriteria;
    }

    @Override
    public String clearSearchCriteria() throws ClientException {
        this.searchCriteria = this.getEmptyVocabularyEntry();
        return this.searchVocabularyEntries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String searchVocabularyEntries() throws ClientException {
        Session vocabulary = null;
        String title = null;
        TreeSet<String> parents = new TreeSet<String>();
        try {
            vocabulary = this.getCurrentVocabulary();
            if (vocabulary != null) {
                this.selectedVocabularyEntries = new ArrayList<VocabularyEntry>();
                HashMap<String, String> filter = new HashMap<String, String>();
                LinkedHashMap<String, String> orderBy = new LinkedHashMap<String, String>();
                HashSet<String> fulltext = new HashSet<String>();
                if (!"".equals(this.searchCriteria.getId())) {
                    filter.put("id", this.searchCriteria.getId());
                    fulltext.add("id");
                }
                if (!"".equals(this.searchCriteria.getLabel())) {
                    filter.put("label", this.searchCriteria.getLabel());
                    fulltext.add("label");
                }
                String parent = this.searchCriteria.getParent();
                if (this.isHierarchical() && parent != null && !parent.equals("")) {
                    if (parent.equals(NULL_MARKER)) {
                        parent = null;
                    }
                    filter.put("parent", parent);
                    fulltext.add("parent");
                }
                orderBy.put("ordering", "asc");
                orderBy.put("id", "asc");
                DocumentModelList vocabularyEntries = vocabulary.query(filter, fulltext, orderBy);
                for (DocumentModel entry : vocabularyEntries) {
                    VocabularyEntry vocabularyEntry = this.getVocabularyEntry(entry);
                    if (vocabularyEntry.getParent() != null) {
                        parents.add(vocabularyEntry.getParent());
                    }
                    this.selectedVocabularyEntries.add(vocabularyEntry);
                }
                title = this.selectedVocabularyEntries.isEmpty() ? "title.vocabulary.entries.empty" : "title.vocabulary.entries";
            }
        }
        catch (SizeLimitExceededException e) {
            title = "".equals(this.searchCriteria) ? "title.vocabulary.entries.error" : "title.vocabulary.entries.search.error";
            log.debug((Object)"The number of the entries of a vocabulary is 0 or greater that the accepted limit...", (Throwable)e);
        }
        finally {
            if (vocabulary != null) {
                vocabulary.close();
            }
        }
        this.parentIds = this.isHierarchical() ? this.computeParentIds(parents) : null;
        this.showAddEntryForm = false;
        this.title = title;
        this.searchCriteria = this.getEmptyVocabularyEntry();
        return "view_vocabulary";
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public List<SelectItem> getParentIds() {
        return this.parentIds;
    }

    protected List<SelectItem> computeParentIds(Set<String> parents) throws ClientException {
        Map messages = this.resourcesAccessor.getMessages();
        ArrayList<SelectItem> parentIds = new ArrayList<SelectItem>(parents.size() + 2);
        parentIds.add(new SelectItem((Object)"", (String)messages.get("vocabulary.entry.any.selectitem")));
        if (this.isNullParentAllowed()) {
            parentIds.add(new SelectItem((Object)NULL_MARKER, (String)messages.get("vocabulary.entry.root.selectitem")));
        }
        for (String parentId : parents) {
            parentIds.add(new SelectItem((Object)parentId, parentId));
        }
        return parentIds;
    }

    protected String getVocabularyName(Directory voc) {
        try {
            return voc.getName();
        }
        catch (DirectoryException e) {
            log.error((Object)"Could not retrieve vocabulary name !", (Throwable)e);
            return null;
        }
    }

    protected Session getVocabularyByName(String name) {
        try {
            return this.dirService.open(name);
        }
        catch (DirectoryException e) {
            log.error((Object)("Failed to lookup directory '" + name + "'"), (Throwable)e);
            return null;
        }
    }

    @PrePassivate
    public void saveState() {
        log.debug((Object)"Saving state before passivation");
    }

    @PostActivate
    public void restoreState() {
        log.debug((Object)"Restoring state upon activation");
        this.initDirService();
        if (this.dirService == null) {
            log.error((Object)"Could not lookup directory service");
            return;
        }
    }

    @Override
    public boolean isHierarchical() throws DirectoryException {
        return "xvocabulary".equals(this.dirService.getDirectorySchema(this.selectedVocabularyName));
    }

    @Override
    public boolean isNullParentAllowed() throws DirectoryException {
        if (this.selectedVocabularyName == null) {
            return false;
        }
        return this.selectedVocabularyName.equals(this.dirService.getParentDirectoryName(this.selectedVocabularyName));
    }

    private VocabularyEntry getEmptyVocabularyEntry() throws ClientException {
        String parent = this.isHierarchical() ? "" : null;
        return new VocabularyEntry("", "", parent);
    }

    @Override
    @Destroy
    @Remove
    public void destroy() {
        log.debug((Object)"Removing Seam component: vocabularyActions");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VocabularyComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = -3178630590907764894L;
        static final Collator collator = Collator.getInstance();
        static final VocabularyComparator INSTANCE;

        private VocabularyComparator() {
        }

        @Override
        public int compare(String d1, String d2) {
            return collator.compare(d1, d2);
        }

        static {
            collator.setStrength(0);
            INSTANCE = new VocabularyComparator();
        }
    }
}

