/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.delegate;

import java.io.Serializable;
import javax.annotation.security.PermitAll;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Unwrap;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.platform.interfaces.ejb.ECDomain;
import org.nuxeo.runtime.api.Framework;

@Name(value="ecDomain")
@Scope(value=ScopeType.CONVERSATION)
public class ECDomainBusinessDelegate
implements Serializable {
    private static final long serialVersionUID = -9197504420097544988L;
    private static final Log log = LogFactory.getLog(ECDomainBusinessDelegate.class);
    protected ECDomain ecDomain;

    public void initialize() {
        log.info((Object)"Seam component initialized...");
    }

    @Unwrap
    public ECDomain getECDomain() throws ClientException {
        if (null == this.ecDomain) {
            try {
                this.ecDomain = (ECDomain)Framework.getService(ECDomain.class);
            }
            catch (Exception e) {
                String errMsg = "Error connecting to ECDomain. " + e.getMessage();
                throw new ClientException(errMsg, (Throwable)e);
            }
            if (null == this.ecDomain) {
                throw new ClientException("ECDomain service not bound");
            }
        }
        return this.ecDomain;
    }

    @Destroy
    @PermitAll
    public void destroy() {
        if (null != this.ecDomain) {
            this.ecDomain.remove();
            this.ecDomain = null;
        }
        log.info((Object)"Destroyed the seam component...");
    }
}

