/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.contentbrowser;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.security.PermitAll;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.util.RepositoryLocation;
import org.nuxeo.ecm.webapp.contentbrowser.ServerActions;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="serverActions")
@Scope(value=ScopeType.CONVERSATION)
public class ServerActionsBean
implements ServerActions,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String DEFAULT_VIEW = "view_domains";
    private static final Log log = LogFactory.getLog(ServerActionsBean.class);
    @In(required=true, create=true)
    protected transient NavigationContext navigationContext;
    private transient RepositoryManager repositoryManager;
    private transient Collection<Repository> availableRepositories;

    @Override
    @Destroy
    @PermitAll
    public void destroy() {
    }

    public void saveState() {
    }

    public void readState() {
    }

    private RepositoryManager getRepositoryManager() throws Exception {
        if (this.repositoryManager == null) {
            this.repositoryManager = (RepositoryManager)Framework.getService(RepositoryManager.class);
        }
        return this.repositoryManager;
    }

    @Override
    @Factory(value="availableCoreRepositories")
    public List<Repository> getAvailableRepositories() throws ClientException {
        try {
            if (this.availableRepositories == null) {
                this.availableRepositories = this.getRepositoryManager().getRepositories();
            }
            ArrayList<Repository> result = new ArrayList<Repository>();
            result.addAll(this.availableRepositories);
            return result;
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    @Override
    public String selectRepository(String repositoryName) throws ClientException {
        try {
            Repository selectedRepository = null;
            for (Repository repo : this.getRepositoryManager().getRepositories()) {
                if (!repo.getName().equals(repositoryName)) continue;
                selectedRepository = repo;
                break;
            }
            log.debug((Object)("Selected core name: " + repositoryName));
            if (selectedRepository != null) {
                RepositoryLocation selectedLocation = new RepositoryLocation(selectedRepository.getName());
                this.navigationContext.setCurrentServerLocation(selectedLocation);
                return DEFAULT_VIEW;
            }
            return null;
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }
}

