/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.contentbrowser;

import java.security.Principal;
import java.util.ArrayList;
import org.jboss.annotation.ejb.SerializedConcurrentAccess;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.webapp.documenttemplates.DocumentTemplatesActions;
import org.nuxeo.ecm.webapp.security.SecurityActions;

@Name(value="isolatedWorkspaceCreator")
@Scope(value=ScopeType.STATELESS)
@SerializedConcurrentAccess
public class IsolatedWorkspaceCreatorBean {
    @In(create=true)
    protected transient Principal currentUser;
    @In(create=true)
    protected transient DocumentTemplatesActions documentTemplatesActions;
    @In(create=true)
    protected transient UserManager userManager;
    @In(create=true)
    protected transient SecurityActions securityActions;

    public String createIsolatedWorkspace() throws ClientException {
        String result = this.documentTemplatesActions.createDocumentFromTemplate();
        ArrayList<String> principalsName = new ArrayList<String>();
        principalsName.add(this.currentUser.getName());
        principalsName.addAll(this.userManager.getAdministratorsGroups());
        for (String principalName : principalsName) {
            this.securityActions.addPermission(principalName, "Everything", true);
        }
        this.securityActions.addPermission("Everyone", "Everything", false);
        this.securityActions.updateSecurityOnDocument();
        return result;
    }
}

