/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.multi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.nuxeo.ecm.directory.AbstractReference;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Reference;
import org.nuxeo.ecm.directory.multi.MultiDirectory;
import org.nuxeo.ecm.directory.multi.MultiDirectoryFactory;
import org.nuxeo.ecm.directory.multi.SourceDescriptor;
import org.nuxeo.ecm.directory.multi.SubDirectoryDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiReference
extends AbstractReference {
    final MultiDirectory dir;
    final String fieldName;

    MultiReference(MultiDirectory dir, String fieldName) {
        this.dir = dir;
        this.fieldName = fieldName;
    }

    public void addLinks(String sourceId, List<String> targetIds) throws DirectoryException {
        throw new UnsupportedOperationException();
    }

    public void addLinks(List<String> sourceIds, String targetId) throws DirectoryException {
        throw new UnsupportedOperationException();
    }

    protected List<String> doCollect(Collector extractor) throws DirectoryException {
        HashSet<String> ids = new HashSet<String>();
        for (SourceDescriptor src : this.dir.getDescriptor().sources) {
            for (SubDirectoryDescriptor sub : src.subDirectories) {
                Reference ref;
                Directory dir = MultiDirectoryFactory.getDirectoryService().getDirectory(sub.name);
                if (dir == null || (ref = dir.getReference(this.fieldName)) == null) continue;
                ids.addAll(extractor.collect(ref));
            }
        }
        ArrayList<String> x = new ArrayList<String>(ids.size());
        x.addAll(ids);
        return x;
    }

    public List<String> getSourceIdsForTarget(final String targetId) throws DirectoryException {
        return this.doCollect(new Collector(){

            @Override
            public List<String> collect(Reference ref) throws DirectoryException {
                return ref.getSourceIdsForTarget(targetId);
            }
        });
    }

    public List<String> getTargetIdsForSource(final String sourceId) throws DirectoryException {
        return this.doCollect(new Collector(){

            @Override
            public List<String> collect(Reference ref) throws DirectoryException {
                return ref.getSourceIdsForTarget(sourceId);
            }
        });
    }

    public void removeLinksForSource(String sourceId) throws DirectoryException {
        throw new UnsupportedOperationException();
    }

    public void removeLinksForTarget(String targetId) throws DirectoryException {
        throw new UnsupportedOperationException();
    }

    public void setSourceIdsForTarget(String targetId, List<String> sourceIds) throws DirectoryException {
        throw new UnsupportedOperationException();
    }

    public void setTargetIdsForSource(String sourceId, List<String> targetIds) throws DirectoryException {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface Collector {
        public List<String> collect(Reference var1) throws DirectoryException;
    }
}

