/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.persistence;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.ejb.Ejb3Configuration;
import org.hibernate.ejb.transaction.JoinableCMTTransactionFactory;
import org.hibernate.transaction.TransactionManagerLookup;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.persistence.EntityManagerFactoryProvider;
import org.nuxeo.ecm.core.persistence.PersistenceError;
import org.nuxeo.runtime.api.DataSourceHelper;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XObject(value="hibernateConfiguration")
public class HibernateConfiguration
implements EntityManagerFactoryProvider {
    public static final String RESOURCE_LOCAL = PersistenceUnitTransactionType.RESOURCE_LOCAL.name();
    public static final String JTA = PersistenceUnitTransactionType.JTA.name();
    public static final String TXTYPE_PROPERTY_NAME = "org.nuxeo.runtime.txType";
    private static final Log log = LogFactory.getLog(HibernateConfiguration.class);
    @XNode(value="@name")
    public String name;
    @XNodeMap(value="properties/property", key="@name", type=Properties.class, componentType=String.class)
    public final Properties hibernateProperties = new Properties();
    @XNodeList(value="classes/class", type=ArrayList.class, componentType=Class.class)
    public final List<Class<?>> annotedClasses = new ArrayList();
    protected Ejb3Configuration cfg;

    @XNode(value="datasource")
    public void setDatasource(String name) {
        String expandedValue = Framework.expandVars((String)name);
        if (expandedValue.startsWith("$")) {
            throw new PersistenceError("Cannot expand " + name + " for datasource");
        }
        this.hibernateProperties.put("hibernate.connection.datasource", DataSourceHelper.getDataSourceJNDIName((String)name));
    }

    public void addAnnotedClass(Class<?> annotedClass) {
        this.annotedClasses.add(annotedClass);
    }

    public void removeAnnotedClass(Class<?> annotedClass) {
        this.annotedClasses.remove(annotedClass);
    }

    public Ejb3Configuration setupConfiguration() {
        this.cfg = new Ejb3Configuration();
        this.cfg.configure(this.name, Collections.emptyMap());
        this.cfg.setProperties(this.hibernateProperties);
        for (Class<?> annotedClass : this.annotedClasses) {
            this.cfg.addAnnotatedClass(annotedClass);
        }
        this.cfg.configure("fake-hibernate.cfg.xml");
        return this.cfg;
    }

    @Override
    public EntityManagerFactory getFactory(String txType) {
        if (this.cfg == null) {
            this.setupConfiguration();
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        if (txType == null) {
            txType = HibernateConfiguration.getTxType();
        }
        if (txType != null) {
            properties.put("javax.persistence.transactionType", txType);
            if (txType.equals(JTA)) {
                properties.put("hibernate.transaction.factory_class", JoinableCMTTransactionFactory.class.getName());
                properties.put("hibernate.transaction.manager_lookup_class", NuxeoTransactionManagerLookup.class.getName());
            }
        }
        return this.cfg.createEntityManagerFactory(properties);
    }

    @Override
    public EntityManagerFactory getFactory() {
        return this.getFactory(null);
    }

    public static String getTxType() {
        String txType;
        if (Framework.isInitialized()) {
            txType = Framework.getProperty((String)TXTYPE_PROPERTY_NAME);
            if (txType == null) {
                try {
                    TransactionHelper.lookupTransactionManager();
                    txType = JTA;
                }
                catch (NamingException e) {
                    txType = RESOURCE_LOCAL;
                }
            }
        } else {
            txType = RESOURCE_LOCAL;
        }
        return txType;
    }

    public static HibernateConfiguration load(URL location) {
        XMap map = new XMap();
        map.register(HibernateConfiguration.class);
        try {
            return (HibernateConfiguration)map.load(location);
        }
        catch (Exception e) {
            throw new PersistenceError("Cannot load hibernate configuration from " + location, e);
        }
    }

    public void merge(HibernateConfiguration other) {
        assert (this.name.equals(other.name)) : " cannot merge configuration that do not have the same persistence unit";
        this.annotedClasses.addAll(other.annotedClasses);
        this.hibernateProperties.clear();
        this.hibernateProperties.putAll((Map<?, ?>)other.hibernateProperties);
    }

    public static class NuxeoTransactionManagerLookup
    implements TransactionManagerLookup {
        public NuxeoTransactionManagerLookup() {
            try {
                TransactionHelper.lookupUserTransaction();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }

        public TransactionManager getTransactionManager(Properties props) throws HibernateException {
            try {
                return TransactionHelper.lookupTransactionManager();
            }
            catch (NamingException e) {
                throw new HibernateException(e.getMessage(), (Throwable)e);
            }
        }

        public String getUserTransactionName() {
            return TransactionHelper.getUserTransactionJNDIName();
        }
    }
}

