/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.relations.api.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.platform.relations.api.Node;
import org.nuxeo.ecm.platform.relations.api.QNameResource;
import org.nuxeo.ecm.platform.relations.api.RelationManager;
import org.nuxeo.ecm.platform.relations.api.Resource;
import org.nuxeo.ecm.platform.relations.api.Statement;
import org.nuxeo.ecm.platform.relations.api.impl.LiteralImpl;
import org.nuxeo.ecm.platform.relations.api.impl.StatementImpl;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationHelper {
    static RelationManager relationManager;
    private static final Log log;

    private RelationHelper() {
    }

    public static RelationManager getRelationManager() {
        try {
            return (RelationManager)Framework.getService(RelationManager.class);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            return null;
        }
    }

    public static QNameResource getDocumentResource(DocumentModel document) throws ClientException {
        QNameResource documentResource = null;
        RelationManager rm = RelationHelper.getRelationManager();
        if (document != null && rm != null) {
            documentResource = (QNameResource)rm.getResource("http://www.nuxeo.org/document/uid/", (Serializable)document, null);
        }
        return documentResource;
    }

    public static DocumentModel getDocumentModel(Node node, String coreSessionId) throws ClientException {
        if (node.isQNameResource()) {
            QNameResource resource = (QNameResource)node;
            HashMap<String, Serializable> context = new HashMap<String, Serializable>();
            context.put("CoreSession", (Serializable)((Object)coreSessionId));
            Serializable o = RelationHelper.getRelationManager().getResourceRepresentation(resource.getNamespace(), resource, context);
            if (o instanceof DocumentModel) {
                return (DocumentModel)o;
            }
        }
        return null;
    }

    public static DocumentModelList getSubjectDocuments(Resource predicat, String stringObject, String sessionId) {
        return RelationHelper.getSubjectDocuments("default", predicat, stringObject, sessionId);
    }

    public static DocumentModelList getSubjectDocuments(String graphName, Resource predicat, String stringObject, String sessionId) {
        try {
            LiteralImpl literal = new LiteralImpl(stringObject);
            StatementImpl pattern = new StatementImpl(null, predicat, literal);
            List<Statement> stmts = RelationHelper.getRelationManager().getStatements(graphName, pattern);
            if (stmts != null) {
                DocumentModelListImpl docs = new DocumentModelListImpl();
                for (Statement stmt : stmts) {
                    DocumentModel d = RelationHelper.getDocumentModel(stmt.getSubject(), sessionId);
                    if (d == null) continue;
                    docs.add((Object)d);
                }
                return docs;
            }
        }
        catch (ClientException e) {
            log.error((Object)e, (Throwable)e);
        }
        return null;
    }

    public static DocumentModelList getSubjectDocuments(Resource predicat, DocumentModel objectDocument) {
        return RelationHelper.getSubjectDocuments("default", predicat, objectDocument);
    }

    public static DocumentModelList getSubjectDocuments(String graphName, Resource predicat, DocumentModel objectDocument) {
        try {
            QNameResource docResource = RelationHelper.getDocumentResource(objectDocument);
            StatementImpl pattern = new StatementImpl(null, predicat, docResource);
            List<Statement> stmts = RelationHelper.getRelationManager().getStatements(graphName, pattern);
            if (stmts != null) {
                DocumentModelListImpl docs = new DocumentModelListImpl();
                for (Statement stmt : stmts) {
                    DocumentModel d = RelationHelper.getDocumentModel(stmt.getSubject(), objectDocument.getSessionId());
                    if (d == null) continue;
                    docs.add((Object)d);
                }
                return docs;
            }
        }
        catch (ClientException e) {
            log.error((Object)e, (Throwable)e);
        }
        return null;
    }

    public static DocumentModelList getSubjectDocumentsOut(Resource predicat, DocumentModel objectDocument) {
        return RelationHelper.getSubjectDocumentsOut("default", predicat, objectDocument);
    }

    public static DocumentModelList getSubjectDocumentsOut(String graphName, Resource predicat, DocumentModel objectDocument) {
        try {
            QNameResource docResource = RelationHelper.getDocumentResource(objectDocument);
            StatementImpl pattern = new StatementImpl(docResource, predicat, null);
            List<Statement> stmts = RelationHelper.getRelationManager().getStatements(graphName, pattern);
            if (stmts != null) {
                DocumentModelListImpl docs = new DocumentModelListImpl();
                for (Statement stmt : stmts) {
                    DocumentModel d = RelationHelper.getDocumentModel(stmt.getObject(), objectDocument.getSessionId());
                    if (d == null) continue;
                    docs.add((Object)d);
                }
                return docs;
            }
        }
        catch (ClientException e) {
            log.error((Object)e, (Throwable)e);
        }
        return null;
    }

    public static DocumentModelList getObjectDocuments(DocumentModel subjectDoc, Resource predicat) {
        return RelationHelper.getObjectDocuments("default", subjectDoc, predicat);
    }

    public static DocumentModelList getObjectDocuments(String graphName, DocumentModel subjectDoc, Resource predicat) {
        try {
            List<Statement> stmts = RelationHelper.getStatements(graphName, subjectDoc, predicat);
            if (stmts != null) {
                DocumentModelListImpl docs = new DocumentModelListImpl();
                for (Statement stmt : stmts) {
                    DocumentModel d = RelationHelper.getDocumentModel(stmt.getObject(), subjectDoc.getSessionId());
                    if (d == null) continue;
                    docs.add((Object)d);
                }
                return docs;
            }
        }
        catch (ClientException e) {
            log.error((Object)e, (Throwable)e);
        }
        return null;
    }

    public static List<Statement> getStatements(DocumentModel subjectDoc, Resource predicat) {
        return RelationHelper.getStatements("default", subjectDoc, predicat);
    }

    public static List<Statement> getStatements(String graphName, DocumentModel subjectDoc, Resource predicat) {
        try {
            QNameResource docResource = RelationHelper.getDocumentResource(subjectDoc);
            StatementImpl pattern = new StatementImpl(docResource, predicat, null);
            return RelationHelper.getRelationManager().getStatements(graphName, pattern);
        }
        catch (ClientException e) {
            log.error((Object)e, (Throwable)e);
            return null;
        }
    }

    public static void removeRelation(DocumentModel subjectDoc, Resource predicat, DocumentModel objectDoc) {
        RelationHelper.removeRelation("default", subjectDoc, predicat, objectDoc);
    }

    public static void removeRelation(String graphName, DocumentModel subjectDoc, Resource predicat, DocumentModel objectDoc) {
        try {
            QNameResource subject = RelationHelper.getDocumentResource(subjectDoc);
            QNameResource object = RelationHelper.getDocumentResource(objectDoc);
            ArrayList<Statement> stmts = new ArrayList<Statement>();
            StatementImpl stmt = new StatementImpl(subject, predicat, object);
            stmts.add(stmt);
            RelationHelper.getRelationManager().remove(graphName, stmts);
        }
        catch (ClientException e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    static {
        log = LogFactory.getLog(RelationHelper.class);
    }
}

