/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.syndication.serializer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.syndication.serializer.DocumentModelListSerializer;
import org.nuxeo.ecm.platform.syndication.serializer.ResultField;
import org.nuxeo.ecm.platform.syndication.serializer.ResultSummary;
import org.nuxeo.ecm.platform.ui.web.tag.fn.DocumentModelFunctions;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.api.DocumentViewCodecManager;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;
import org.restlet.data.MediaType;
import org.restlet.data.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDocumentModelSerializer
implements DocumentModelListSerializer {
    protected UserManager um = null;

    @Override
    public String serialize(DocumentModelList docList, List<String> columnsDefinition, HttpServletRequest req) throws ClientException {
        return this.serialize(null, docList, columnsDefinition, req);
    }

    @Override
    public String serialize(ResultSummary summary, DocumentModelList docList, List<String> columnsDefinition, HttpServletRequest req) throws ClientException {
        return null;
    }

    @Override
    public String serialize(DocumentModelList docList, String columnsDefinition, HttpServletRequest req) throws ClientException {
        if (columnsDefinition == null) {
            return this.serialize(docList, new ArrayList<String>(), req);
        }
        String[] cols = columnsDefinition.split(",");
        return this.serialize(docList, Arrays.asList(cols), req);
    }

    @Override
    public String serialize(ResultSummary summary, DocumentModelList docList, String columnsDefinition, HttpServletRequest req) throws ClientException {
        if (columnsDefinition == null) {
            return this.serialize(summary, docList, new ArrayList<String>(), req);
        }
        String[] cols = columnsDefinition.split(",");
        return this.serialize(summary, docList, Arrays.asList(cols), req);
    }

    @Override
    public void serialize(DocumentModelList docList, String columnsDefinition, Response res, HttpServletRequest req) throws ClientException {
        String xml = this.serialize(docList, columnsDefinition, req);
        res.setEntity(xml, MediaType.TEXT_XML);
    }

    @Override
    public void serialize(ResultSummary summary, DocumentModelList docList, String columnsDefinition, Response res, HttpServletRequest req) throws ClientException {
        String xml = this.serialize(summary, docList, columnsDefinition, req);
        res.setEntity(xml, MediaType.TEXT_XML);
    }

    @Override
    public void serialize(ResultSummary summary, DocumentModelList docList, String columnsDefinition, Response res, HttpServletRequest req, List<String> labels, String lang) throws ClientException {
        this.serialize(summary, docList, columnsDefinition, res, req);
    }

    protected String getFullUserName(String login) throws Exception {
        NuxeoPrincipal principal;
        String fullname = login;
        if (this.um == null) {
            this.um = (UserManager)Framework.getService(UserManager.class);
        }
        if ((principal = this.um.getPrincipal(login)) != null) {
            fullname = principal.getFirstName() + " " + principal.getLastName();
        }
        return fullname;
    }

    protected ResultField getDocumentProperty(DocumentModel doc, String colDef) throws ClientException {
        ResultField res = null;
        if (colDef.equals("url")) {
            String url = AbstractDocumentModelSerializer.getDocumentURL(doc);
            return new ResultField("url", url);
        }
        if (colDef.contains("icon")) {
            String icon = DocumentModelFunctions.iconPath((DocumentModel)doc);
            return new ResultField("icon", icon);
        }
        if (colDef.contains("path")) {
            String path = doc.getPath().toString();
            return new ResultField("path", path);
        }
        if (colDef.equals("type")) {
            String type = doc.getType();
            return new ResultField("type", type);
        }
        if (colDef.equals("currentLifecycleState")) {
            String state = doc.getCurrentLifeCycleState();
            return new ResultField("currentLifecycleState", state);
        }
        if (colDef.contains("author")) {
            String authorLogin = (String)doc.getProperty("dublincore", "creator");
            try {
                String author = this.getFullUserName(authorLogin);
                return new ResultField("author", author);
            }
            catch (Exception e) {
                return new ResultField("author", authorLogin);
            }
        }
        if (colDef.contains(".")) {
            String[] params = colDef.split("\\.");
            if (params.length == 2) {
                String schemaName = params[0].trim();
                String fieldName = params[1].trim();
                if (fieldName.contains("[")) {
                    int pos = fieldName.indexOf("[");
                    String sIndex = fieldName.substring(pos + 1, pos + 2);
                    String realFieldName = fieldName.substring(0, pos);
                    List<Object> list = Arrays.asList((Object[])doc.getProperty(schemaName, realFieldName));
                    if (list != null && !list.isEmpty()) {
                        return new ResultField(fieldName, (String)list.get(Integer.parseInt(sIndex)));
                    }
                    return null;
                }
                Object property = doc.getProperty(schemaName, fieldName);
                if (property instanceof String) {
                    res = new ResultField(fieldName, (String)doc.getProperty(schemaName, fieldName));
                } else if (property instanceof Long) {
                    res = new ResultField(fieldName, doc.getProperty(schemaName, fieldName).toString());
                } else if (property instanceof Calendar) {
                    String date = DATE_PARSER.format(((Calendar)doc.getProperty(schemaName, fieldName)).getTime());
                    res = new ResultField(fieldName, date);
                } else if (property instanceof Object[]) {
                    List<Object> list = Arrays.asList((Object[])doc.getProperty(schemaName, fieldName));
                    res = new ResultField(fieldName, list.toString());
                } else if (property instanceof List) {
                    List list = (List)doc.getProperty(schemaName, fieldName);
                    res = new ResultField(fieldName, list.toString());
                } else {
                    res = new ResultField(fieldName, null);
                }
            } else {
                res = new ResultField(colDef, null);
            }
        } else {
            String result = null;
            for (String schemaName : doc.getDeclaredSchemas()) {
                result = (String)doc.getProperty(schemaName, colDef);
                if (result == null) continue;
            }
            res = new ResultField(colDef, result);
        }
        return res;
    }

    protected static String getDocumentURL(DocumentModel doc) {
        DocumentViewCodecManager dvcm;
        try {
            dvcm = (DocumentViewCodecManager)Framework.getService(DocumentViewCodecManager.class);
        }
        catch (Exception e) {
            return null;
        }
        return dvcm.getUrlFromDocumentView((DocumentView)new DocumentViewImpl(doc), false, null);
    }
}

