/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.syndication;

import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.SyndFeedOutput;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.syndication.FeedItem;
import org.nuxeo.ecm.platform.syndication.FeedItemAdapter;
import org.nuxeo.ecm.platform.syndication.SyndicationActions;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.platform.ui.web.util.BaseURL;
import org.nuxeo.ecm.platform.util.RepositoryLocation;
import org.nuxeo.ecm.webapp.search.SearchActions;
import org.nuxeo.ecm.webapp.search.SearchType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="syndication")
@Scope(value=ScopeType.EVENT)
public class SyndicationActionsBean
implements SyndicationActions {
    private static final Log log = LogFactory.getLog(SyndicationActionsBean.class);
    public static final String RSS_TYPE = "rss_2.0";
    public static final String ATOM_TYPE_OLD = "atom_0.3";
    public static final String ATOM_TYPE = "atom_1.0";
    public static final String DEFAULT_TYPE = "rss_2.0";
    @RequestParameter
    protected String docRef;
    protected static final String DOCREF_KEY = "docRef";
    @RequestParameter
    protected String feedType;
    protected static final String FEEDTYPE_KEY = "feedType";
    @RequestParameter
    protected String searchQuery;
    protected static final String SEARCHQUERY_KEY = "searchQuery";
    @RequestParameter
    protected String repositoryId;
    protected static final String REPOSITORYID_KEY = "repositoryId";
    protected static final String DEFAULT_REPOSITORY = "default";
    protected static final String DOCUMENT_SYNDICATION_PATH = "getSyndicationDocument.faces";
    private static final String SEARCH_SYNDICATION_PATH = "getSyndicationSearch.faces";

    @Override
    @Begin(id="#{conversationIdGenerator.currentOrNewMainConversationId}", join=true)
    public void getSyndicationDocument() throws ClientException {
        DocumentModel doc;
        String[] split;
        if (this.docRef == null || "".equals(this.docRef)) {
            throw new IllegalArgumentException("Missing docRef");
        }
        if (this.feedType == null || "".equals(this.feedType)) {
            this.feedType = "rss_2.0";
        }
        if ((split = this.docRef.split("/", 2)).length != 2) {
            throw new IllegalArgumentException("Invalid docRef");
        }
        String serverLocation = split[0];
        String docId = split[1];
        if (docId.startsWith("1:")) {
            docId = docId.substring(2);
            this.docRef = serverLocation + '/' + docId;
        }
        IdRef idRef = new IdRef(docId);
        NavigationContext navigationContext = (NavigationContext)Component.getInstance((String)"navigationContext", (boolean)true);
        navigationContext.setCurrentServerLocation(new RepositoryLocation(serverLocation));
        CoreSession documentManager = navigationContext.getOrCreateDocumentManager();
        try {
            doc = documentManager.getDocument((DocumentRef)idRef);
        }
        catch (DocumentSecurityException e) {
            SyndicationActionsBean.sendForbidden();
            return;
        }
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setFeedType(this.feedType);
        String title = (String)doc.getProperty("dublincore", "title");
        if (title == null || "".equals(title)) {
            title = " ";
        }
        feed.setTitle(title);
        String description = (String)doc.getProperty("dublincore", "description");
        if (description == null || "".equals(description)) {
            description = " ";
        }
        feed.setDescription(description);
        feed.setLink(SyndicationActionsBean.getFeedUrl(DOCUMENT_SYNDICATION_PATH, DOCREF_KEY, this.docRef, this.feedType));
        DocumentModelListImpl children = new DocumentModelListImpl();
        for (DocumentModel child : documentManager.getChildren((DocumentRef)idRef)) {
            if ("deleted".equals(child.getCurrentLifeCycleState())) continue;
            children.add((Object)child);
        }
        List<FeedItem> feedItems = SyndicationActionsBean.getFeedItems((List<DocumentModel>)children);
        Collections.sort(feedItems, Collections.reverseOrder());
        feed.setEntries(feedItems);
        SyndicationActionsBean.writeFeed((SyndFeed)feed);
    }

    @Override
    @Begin(id="#{conversationIdGenerator.currentOrNewMainConversationId}", join=true)
    public void getSyndicationSearch() throws ClientException {
        if (this.searchQuery == null || "".equals(this.searchQuery)) {
            this.searchQuery = "";
        }
        this.searchQuery = this.searchQuery.replace('\n', ' ').replaceAll(" +", " ");
        if (this.feedType == null || "".equals(this.feedType)) {
            this.feedType = "rss_2.0";
        }
        if (this.repositoryId == null || "".equals(this.repositoryId)) {
            this.repositoryId = DEFAULT_REPOSITORY;
        }
        NavigationContext navigationContext = (NavigationContext)Component.getInstance((String)"navigationContext", (boolean)true);
        navigationContext.setCurrentServerLocation(new RepositoryLocation(this.repositoryId));
        SearchActions searchActions = (SearchActions)Component.getInstance((String)"searchActions", (boolean)true);
        searchActions.setSearchTypeId(SearchType.NXQL.name());
        searchActions.setNxql(this.searchQuery);
        searchActions.performSearch();
        List<DocumentModel> docList = searchActions.getResultDocuments("SEARCH_BEAN_NXQL_PROVIDER");
        if (docList == null) {
            docList = Collections.emptyList();
        }
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setFeedType(this.feedType);
        feed.setTitle("Search results");
        feed.setDescription("Query: " + this.searchQuery);
        feed.setLink(SyndicationActionsBean.getFeedUrl(SEARCH_SYNDICATION_PATH, SEARCHQUERY_KEY, this.searchQuery, REPOSITORYID_KEY, SyndicationActionsBean.getRepositoryId(), this.feedType));
        List<FeedItem> feedItems = SyndicationActionsBean.getFeedItems(docList);
        feed.setEntries(feedItems);
        SyndicationActionsBean.writeFeed((SyndFeed)feed);
    }

    protected static List<FeedItem> getFeedItems(List<DocumentModel> docs) throws ClientException {
        return FeedItemAdapter.toFeedItemList(docs, null);
    }

    protected static String urlencode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected static String getFeedUrl(String path, String key, String value, String feedType) {
        return SyndicationActionsBean.getFeedUrl(path, key, value, null, null, feedType);
    }

    protected static String getFeedUrl(String path, String key1, String value1, String key2, String value2, String feedType) {
        StringBuilder url = new StringBuilder();
        url.append(BaseURL.getBaseURL());
        url.append(path);
        url.append('?');
        url.append(key1);
        url.append('=');
        url.append(SyndicationActionsBean.urlencode(value1));
        if (key2 != null) {
            url.append('&');
            url.append(key2);
            url.append('=');
            url.append(SyndicationActionsBean.urlencode(value2));
        }
        url.append('&');
        url.append(FEEDTYPE_KEY);
        url.append('=');
        if (feedType != null) {
            url.append(SyndicationActionsBean.urlencode(feedType));
        }
        return url.toString();
    }

    protected static void writeFeed(SyndFeed feed) {
        FacesContext context = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        response.setContentType("application/xml; charset=UTF-8");
        try {
            new SyndFeedOutput().output(feed, (Writer)response.getWriter());
        }
        catch (Exception e) {
            log.error((Object)"Unable to output feed", (Throwable)e);
        }
        context.responseComplete();
    }

    protected static void sendForbidden() {
        FacesContext context = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        response.setStatus(403);
        context.responseComplete();
    }

    protected static String getRepositoryId() {
        NavigationContext navigationContext = (NavigationContext)Component.getInstance((String)"navigationContext", (boolean)true);
        if (navigationContext == null) {
            return DEFAULT_REPOSITORY;
        }
        RepositoryLocation sl = navigationContext.getCurrentServerLocation();
        return sl == null ? DEFAULT_REPOSITORY : sl.getName();
    }

    @Override
    @Factory(value="fullSyndicationDocumentUrl", scope=ScopeType.EVENT)
    public String getFullSyndicationDocumentUrl() {
        return SyndicationActionsBean.getCurrentDocumentSyndicationUrl(null);
    }

    @Override
    @Deprecated
    public String getFullSyndicationDocumentUrlInRss() {
        return SyndicationActionsBean.getCurrentDocumentSyndicationUrl("rss_2.0");
    }

    @Override
    @Deprecated
    public String getFullSyndicationDocumentUrlInAtom() {
        return SyndicationActionsBean.getCurrentDocumentSyndicationUrl(ATOM_TYPE);
    }

    protected static String getCurrentDocumentSyndicationUrl(String feedType) {
        NavigationContext navigationContext = (NavigationContext)Component.getInstance((String)"navigationContext", (boolean)true);
        if (navigationContext == null) {
            return null;
        }
        String serverLocation = navigationContext.getCurrentServerLocation().getName();
        String docId = navigationContext.getCurrentDocument().getId();
        String docRef = serverLocation + '/' + docId;
        return SyndicationActionsBean.getFeedUrl(DOCUMENT_SYNDICATION_PATH, DOCREF_KEY, docRef, feedType);
    }

    @Override
    @Factory(value="fullSyndicationSearchUrl", scope=ScopeType.EVENT)
    public String getFullSyndicationSearchUrl() {
        return SyndicationActionsBean.getSearchSyndicationUrl(null);
    }

    @Override
    @Deprecated
    public String getFullSyndicationSearchUrlInRss() {
        return SyndicationActionsBean.getSearchSyndicationUrl("rss_2.0");
    }

    @Override
    @Deprecated
    public String getFullSyndicationSearchUrlInAtom() {
        return SyndicationActionsBean.getSearchSyndicationUrl(ATOM_TYPE);
    }

    protected static String getSearchSyndicationUrl(String feedType) {
        SearchActions searchActions = (SearchActions)Component.getInstance((String)"searchActions", (boolean)true);
        if (searchActions == null) {
            return null;
        }
        String searchQuery = searchActions.getLatestNxql();
        if (searchQuery == null) {
            throw new IllegalArgumentException("null searchQuery");
        }
        searchQuery = searchQuery.replace('\n', ' ').replaceAll(" +", " ");
        return SyndicationActionsBean.getFeedUrl(SEARCH_SYNDICATION_PATH, SEARCHQUERY_KEY, searchQuery, REPOSITORYID_KEY, SyndicationActionsBean.getRepositoryId(), feedType);
    }

    @Override
    @Deprecated
    @Begin(id="#{conversationIdGenerator.currentOrNewMainConversationId}", join=true)
    public List<Action> getActionsForSyndication() {
        WebActions webActions = (WebActions)Component.getInstance((String)"webActions", (boolean)true);
        return webActions.getActionsList("SYNDICATION_LINKS");
    }
}

