/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.ldap.dns;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DNSServiceEntry
implements Comparable<DNSServiceEntry> {
    private final String host;
    private final int port;
    private final int priority;
    private final int weight;

    public DNSServiceEntry(String host, int port, int priority, int weight) {
        this.host = host;
        this.port = port;
        this.priority = priority;
        this.weight = weight;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getWeight() {
        return this.weight;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return this.host + ":" + this.port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DNSServiceEntry)) {
            return false;
        }
        DNSServiceEntry address = (DNSServiceEntry)o;
        if (!this.host.equals(address.host)) {
            return false;
        }
        return this.port == address.port;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public int compareTo(DNSServiceEntry o) {
        if (o.priority == this.priority) {
            return o.weight - this.weight;
        }
        return this.priority - o.priority;
    }
}

