/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.scheduler.core;

import java.io.Serializable;
import java.security.Principal;
import java.util.Map;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.impl.UserPrincipal;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.ecm.core.event.impl.EventImpl;
import org.nuxeo.runtime.api.Framework;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class EventJob
implements Job {
    private static final Log log = LogFactory.getLog(EventJob.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        block18: {
            JobDataMap dataMap = context.getJobDetail().getJobDataMap();
            String eventId = dataMap.getString("eventId");
            String eventCategory = dataMap.getString("eventCategory");
            String username = dataMap.getString("username");
            LoginContext lContext = null;
            try {
                lContext = Framework.login((String)username, (Object)dataMap.getString("password"));
            }
            catch (LoginException e) {
                log.error((Object)e);
                return;
            }
            try {
                UserPrincipal principal = new UserPrincipal(username);
                EventContextImpl ctx = new EventContextImpl(null, (Principal)principal);
                ctx.setProperty("category", (Serializable)((Object)eventCategory));
                ctx.setProperties((Map)dataMap);
                EventImpl event = new EventImpl(eventId, (EventContext)ctx);
                EventService evtService = null;
                evtService = (EventService)Framework.getService(EventService.class);
                if (evtService != null) {
                    log.info((Object)("Sending scheduled event id=" + eventId + ", category=" + eventCategory));
                    ClassLoader jbossCL = Thread.currentThread().getContextClassLoader();
                    ClassLoader nuxeoCL = EventJob.class.getClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader(nuxeoCL);
                        evtService.fireEvent((Event)event);
                        break block18;
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(jbossCL);
                    }
                }
                log.error((Object)"Cannot find EventService");
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
            finally {
                if (lContext != null) {
                    try {
                        lContext.logout();
                    }
                    catch (Exception e) {
                        log.error((Object)e, (Throwable)e);
                    }
                }
            }
        }
    }
}

