/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.runtime.annotations.AnnotatedMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedClass<T> {
    protected AnnotatedClass<?> superClass;
    protected final Class<T> clazz;
    protected final Map<Class<? extends Annotation>, Annotation> annotations;
    protected final Map<Method, AnnotatedMethod> methods;

    public AnnotatedClass(Class<T> clazz) {
        this.clazz = clazz;
        this.methods = new HashMap<Method, AnnotatedMethod>();
        this.annotations = new HashMap<Class<? extends Annotation>, Annotation>();
    }

    public Class<?> getAnnotatedClass() {
        return this.clazz;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        return (A)this.annotations.get(annotationClass);
    }

    public <A extends Annotation> A getDeclaredAnnotation(Class<A> annotationClass) {
        return this.clazz.getAnnotation(annotationClass);
    }

    public Annotation[] getAnnotations() {
        return this.annotations.values().toArray(new Annotation[this.annotations.size()]);
    }

    public Annotation[] getDeclaredAnnotations() {
        return this.clazz.getDeclaredAnnotations();
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.annotations.containsKey(annotationClass);
    }

    public boolean isDeclaringAnnotation(Class<? extends Annotation> annotationClass) {
        return this.clazz.isAnnotationPresent(annotationClass);
    }

    public AnnotatedMethod getAnnotatedMethod(Method method) {
        return this.methods.get(method);
    }

    public AnnotatedMethod getAnnotatedMethod(String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        return this.getAnnotatedMethod(this.clazz.getMethod(name, parameterTypes));
    }

    public AnnotatedMethod getDeclaredAnnotatedMethod(Method method) {
        AnnotatedMethod am = this.methods.get(method);
        return am != null && am.method.getDeclaringClass() == this.clazz ? am : null;
    }

    public boolean hasAnnotatedMethods() {
        return !this.methods.isEmpty();
    }

    public boolean isDeclaringAnnotatedMethods() {
        if (this.methods.isEmpty()) {
            return false;
        }
        for (AnnotatedMethod am : this.methods.values()) {
            if (am.method.getDeclaringClass() != this.clazz) continue;
            return true;
        }
        return false;
    }

    public AnnotatedMethod[] getAnnotatedMethods() {
        return this.methods.values().toArray(new AnnotatedMethod[this.methods.size()]);
    }

    public AnnotatedMethod[] getDeclaredAnnotatedMethods() {
        ArrayList<AnnotatedMethod> result = new ArrayList<AnnotatedMethod>();
        for (AnnotatedMethod am : this.methods.values()) {
            if (am.method.getDeclaringClass() != this.clazz) continue;
            result.add(am);
        }
        return result.toArray(new AnnotatedMethod[result.size()]);
    }

    public AnnotatedMethod[] getAnnotatedMethods(Class<? extends Annotation> annotationClass) {
        ArrayList<AnnotatedMethod> result = new ArrayList<AnnotatedMethod>();
        for (AnnotatedMethod am : this.methods.values()) {
            if (!am.annotations.containsKey(annotationClass)) continue;
            result.add(am);
        }
        return result.toArray(new AnnotatedMethod[result.size()]);
    }

    public AnnotatedMethod[] getDeclaredAnnotatedMethods(Class<? extends Annotation> annotationClass) {
        ArrayList<AnnotatedMethod> result = new ArrayList<AnnotatedMethod>();
        for (AnnotatedMethod am : this.methods.values()) {
            if (am.method.getDeclaringClass() != this.clazz || !am.annotations.containsKey(annotationClass)) continue;
            result.add(am);
        }
        return result.toArray(new AnnotatedMethod[result.size()]);
    }

    public void addMethod(AnnotatedMethod method) {
        this.methods.put(method.method, method);
    }

    public int hashCode() {
        return this.clazz.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() == AnnotatedClass.class) {
            return ((AnnotatedClass)obj).clazz == this.clazz;
        }
        return false;
    }

    public String toString() {
        return "AnnotatedCass: " + this.clazz;
    }
}

