/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.model.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.ModuleResource;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.ecm.webengine.scripting.ScriptFile;

public class ModuleRoot
extends DefaultObject
implements ModuleResource {
    @GET
    @Path(value="skin/{path:.*}")
    public Response getSkinResource(@PathParam(value="path") String path) {
        try {
            ScriptFile file = this.getModule().getSkinResource("/resources/" + path);
            if (file != null) {
                long lastModified = file.lastModified();
                Response.ResponseBuilder resp = Response.ok((Object)file.getFile()).lastModified(new Date(lastModified)).header("Cache-Control", (Object)"public").header("Server", (Object)"Nuxeo/WebEngine-1.0");
                String mimeType = this.ctx.getEngine().getMimeType(file.getExtension());
                if (mimeType == null) {
                    mimeType = "text/plain";
                }
                resp.type(mimeType);
                return resp.build();
            }
        }
        catch (IOException e) {
            throw WebException.wrap("Failed to get resource file: " + path, e);
        }
        return Response.status((int)404).build();
    }

    public String getLink(DocumentModel doc) {
        return this.getPath() + "/@nxdoc/" + doc.getId();
    }

    public Object handleError(WebApplicationException e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        pw.close();
        return Response.status((int)500).entity((Object)sw.toString()).build();
    }
}

