/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.login;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.ui.web.auth.CachableUserIdentificationInfo;
import org.nuxeo.ecm.platform.ui.web.auth.plugins.DefaultSessionManager;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.ecm.webengine.login.WebEngineFormAuthenticator;
import org.nuxeo.ecm.webengine.session.StatefulUserSession;
import org.nuxeo.ecm.webengine.session.StatelessUserSession;
import org.nuxeo.ecm.webengine.session.UserSession;

public class WebEngineSessionManager
extends DefaultSessionManager {
    private static final String RESOURCES_PATH = VirtualHostHelper.getContextPathProperty() + "/site/files/";
    private static final Log log = LogFactory.getLog(WebEngineSessionManager.class);

    public boolean canBypassRequest(ServletRequest request) {
        return ((HttpServletRequest)request).getRequestURI().startsWith(RESOURCES_PATH);
    }

    public void onAuthenticatedSessionCreated(ServletRequest request, HttpSession httpSession, CachableUserIdentificationInfo cachebleUserInfo) {
        UserSession userSession;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (httpSession == null) {
            httpSession = httpRequest.getSession(false);
        }
        if (httpSession == null) {
            userSession = new StatelessUserSession(cachebleUserInfo.getPrincipal(), cachebleUserInfo.getUserInfo().getPassword());
            log.debug((Object)"Creating Stateless UserSession");
        } else {
            userSession = new StatefulUserSession(cachebleUserInfo.getPrincipal(), cachebleUserInfo.getUserInfo().getPassword());
            log.debug((Object)"Creating Stateful UserSession");
        }
        UserSession.register(httpRequest, userSession);
    }

    public boolean needResetLogin(ServletRequest req) {
        return WebEngineFormAuthenticator.isLoginRequest((HttpServletRequest)req);
    }
}

