/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.debug;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.webengine.debug.FileEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryEntry
extends FileEntry {
    protected List<FileEntry> entries;

    public DirectoryEntry(File file) {
        super(file);
    }

    public List<FileEntry> getChildren() {
        if (this.entries == null) {
            this.entries = new ArrayList<FileEntry>();
            this.collectChildren();
        }
        return this.entries;
    }

    protected void collectChildren() {
        if (!this.file.isDirectory()) {
            return;
        }
        for (File f : this.file.listFiles()) {
            if (!f.isDirectory()) continue;
            this.entries.add(new DirectoryEntry(f));
        }
    }

    @Override
    public boolean check() {
        if (super.check()) {
            this.entries = null;
            return true;
        }
        for (FileEntry entry : this.getChildren()) {
            if (!entry.check()) continue;
            return true;
        }
        return false;
    }
}

