/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.app.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SuperKeyedRegistry<K, V> {
    private static final Object NULL = new Object();
    protected K root;
    protected Map<K, V> registry;
    protected volatile ConcurrentMap<K, Object> lookup;
    private final Object lock = new Object();

    public SuperKeyedRegistry(K root) {
        this.root = root;
        this.registry = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, V value) {
        Object object = this.lock;
        synchronized (object) {
            this.registry.put(key, value);
            this.lookup = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(K key) {
        V value;
        Object object = this.lock;
        synchronized (object) {
            value = this.registry.remove(key);
            this.lookup = null;
        }
        return value;
    }

    protected boolean isRoot(K key) {
        return key == this.root;
    }

    protected abstract K getSuperKey(K var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        K sk;
        Object v;
        ConcurrentMap<K, Object> _lookup = this.lookup;
        if (_lookup == null) {
            Object object = this.lock;
            synchronized (object) {
                this.lookup = new ConcurrentHashMap<K, Object>(this.registry);
                _lookup = this.lookup;
            }
        }
        if ((v = _lookup.get(key)) == null && !this.isRoot(key) && (sk = this.getSuperKey(key)) != null) {
            v = this.get(sk);
            if (v != null) {
                _lookup.put(key, v);
            } else {
                _lookup.put(key, NULL);
            }
        }
        return v == NULL ? null : (V)v;
    }
}

