/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.app.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.nuxeo.ecm.webengine.app.annotations.ResourceExtension;
import org.nuxeo.ecm.webengine.app.extensions.ExtensibleResource;
import org.nuxeo.ecm.webengine.app.extensions.ResourceContribution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceContributions {
    protected Class<?> target;
    protected Map<String, ResourceContribution> contribs;
    protected ConcurrentMap<String, List<ResourceContribution>> contribsByCategories;

    public ResourceContributions(Class<?> target) {
        this.target = target;
        this.contribs = new HashMap<String, ResourceContribution>();
        this.contribsByCategories = new ConcurrentHashMap<String, List<ResourceContribution>>();
    }

    public Class<?> getTarget() {
        return this.target;
    }

    public ResourceContribution getContribution(String key) {
        return this.contribs.get(key);
    }

    public ResourceContribution[] getContributions() {
        return this.contribs.values().toArray(new ResourceContribution[this.contribs.size()]);
    }

    public List<ResourceContribution> getContributions(ExtensibleResource target, String category) {
        List<ResourceContribution> contribs = this.getContributions(target.getClass(), category);
        if (!contribs.isEmpty()) {
            ArrayList<ResourceContribution> result = new ArrayList<ResourceContribution>();
            for (ResourceContribution c : contribs) {
                if (!c.accept(target)) continue;
                result.add(c);
            }
            return result;
        }
        return contribs;
    }

    public List<ResourceContribution> getContributions(Class<? extends ExtensibleResource> target, String category) {
        ArrayList<ResourceContribution> result = (ArrayList<ResourceContribution>)this.contribsByCategories.get(category);
        if (result == null) {
            result = new ArrayList<ResourceContribution>();
            for (ResourceContribution c : this.contribs.values()) {
                if (!c.hasCategory(category)) continue;
                result.add(c);
            }
            this.contribsByCategories.put(category, result);
        }
        return result;
    }

    public void addContribution(ResourceContribution c) throws Exception {
        this.contribs.put(c.getKey(), c);
    }

    public void removeContribution(String key) {
        this.contribs.remove(key);
    }

    public void addContribution(Class<? extends ResourceContribution> contrib) throws Exception {
        ResourceContribution c = contrib.newInstance();
        this.addContribution(c);
    }

    public void removeContribution(Class<?> contrib) {
        ResourceExtension xt = contrib.getAnnotation(ResourceExtension.class);
        if (xt != null) {
            this.removeContribution(xt.key());
        }
    }
}

