/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.app.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.app.BundledApplication;
import org.nuxeo.ecm.webengine.app.ModuleHandler;
import org.nuxeo.ecm.webengine.app.annotations.ResourceExtension;
import org.nuxeo.ecm.webengine.app.extensions.ExtensibleResource;
import org.nuxeo.ecm.webengine.app.extensions.ResourceContribution;
import org.nuxeo.ecm.webengine.app.impl.ClassRegistry;
import org.nuxeo.ecm.webengine.app.impl.ResourceContributions;
import org.nuxeo.ecm.webengine.model.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleRegistry {
    private static final Log log = LogFactory.getLog(ModuleRegistry.class);
    protected WebEngine engine;
    protected Map<String, ModuleHandler> modules;
    protected Map<String, ModuleHandler> modulesByRoot;
    protected ClassRegistry<ResourceContributions> contributions;

    public ModuleRegistry(WebEngine engine) {
        this.engine = engine;
        this.modules = new HashMap<String, ModuleHandler>();
        this.modulesByRoot = new HashMap<String, ModuleHandler>();
        this.contributions = new ClassRegistry(ExtensibleResource.class);
    }

    public ModuleHandler[] getModuleHandlers() {
        return this.modulesByRoot.values().toArray(new ModuleHandler[this.modulesByRoot.size()]);
    }

    public ModuleHandler getModuleHandlerFor(Class<?> rootResource) {
        return this.modulesByRoot.get(rootResource.getName());
    }

    public ModuleHandler getModuleHandler(String appId) {
        return this.modules.get(appId);
    }

    public void addApplication(BundledApplication app) {
        if (app.isWebEngineModule()) {
            Class<?>[] rc;
            ModuleHandler mh = new ModuleHandler(this.engine, app);
            this.modules.put(app.getId(), mh);
            for (Class<?> c : rc = mh.getRootClasses()) {
                this.modulesByRoot.put(c.getName(), mh);
            }
            this.addContributions(app, mh);
        }
    }

    public BundledApplication removeApplication(BundledApplication app) {
        ModuleHandler mh = this.modules.remove(app.getId());
        if (mh != null) {
            Class<?>[] rc;
            for (Class<?> c : rc = mh.getRootClasses()) {
                this.modulesByRoot.remove(c.getName());
            }
            this.removeContributions(app, mh);
        }
        return app;
    }

    public Object getContribution(Resource target, String key) throws Exception {
        ResourceContribution c;
        ResourceContributions rcs = (ResourceContributions)this.contributions.get(target.getClass());
        if (rcs != null && (c = rcs.getContribution(key)) != null && c.accept(target)) {
            return c.newInstance(target);
        }
        return null;
    }

    public ResourceContribution getContribution(Class<? extends ExtensibleResource> target, String key) throws Exception {
        ResourceContribution c;
        ResourceContributions rcs = (ResourceContributions)this.contributions.get(target);
        if (rcs != null && (c = rcs.getContribution(key)) != null) {
            return c;
        }
        return null;
    }

    public List<ResourceContribution> getContributions(ExtensibleResource target, String category) {
        ResourceContributions rcs = (ResourceContributions)this.contributions.get(target.getClass());
        if (rcs != null) {
            return rcs.getContributions(target, category);
        }
        return null;
    }

    public List<ResourceContribution> getContributions(Class<? extends ExtensibleResource> target, String category) {
        ResourceContributions rcs = (ResourceContributions)this.contributions.get(target.getClass());
        if (rcs != null) {
            return rcs.getContributions(target, category);
        }
        return null;
    }

    protected void addContributions(BundledApplication app, ModuleHandler mh) {
        Class<? extends ResourceContribution>[] xts = mh.getContributions();
        if (xts != null && xts.length > 0) {
            for (Class<? extends ResourceContribution> xt : xts) {
                ResourceExtension rxt = xt.getAnnotation(ResourceExtension.class);
                if (rxt == null) {
                    throw new Error("Trying to export a resource extension which is not annotated with " + ResourceExtension.class + " in bundle " + app.getId() + ", resource extension: " + xt);
                }
                Class<? extends ExtensibleResource> target = rxt.target();
                try {
                    ResourceContribution rc = xt.newInstance();
                    this.addContributionFor(target, rc);
                }
                catch (Exception e) {
                    log.error((Object)("Failed to register contribution: " + xt), (Throwable)e);
                }
            }
        }
    }

    protected void addContributionFor(Class<? extends ExtensibleResource> target, ResourceContribution rc) throws Exception {
        ResourceContributions rcs = (ResourceContributions)this.contributions.get(target);
        if (rcs == null) {
            rcs = new ResourceContributions(target);
            this.contributions.put(target, rcs);
        }
        rcs.addContribution(rc);
    }

    protected void removeContributions(BundledApplication app, ModuleHandler mh) {
        Class<? extends ResourceContribution>[] xts = mh.getContributions();
        if (xts != null && xts.length > 0) {
            for (Class<? extends ResourceContribution> xt : xts) {
                ResourceExtension rxt = xt.getAnnotation(ResourceExtension.class);
                if (rxt == null) {
                    throw new Error("Trying to remove a resource extension which is not annotated with " + ResourceExtension.class + " in bundle " + app.getId() + ", resource extension: " + xt);
                }
                ResourceContributions rcs = (ResourceContributions)this.contributions.get(rxt.target());
                if (rcs == null) continue;
                rcs.removeContribution(rxt.key());
            }
        }
    }
}

