/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.app.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.ws.rs.core.MediaType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.webengine.ResourceBinding;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.app.ModuleHandler;
import org.nuxeo.ecm.webengine.app.WebEngineModule;
import org.nuxeo.ecm.webengine.model.AdapterType;
import org.nuxeo.ecm.webengine.model.LinkDescriptor;
import org.nuxeo.ecm.webengine.model.Messages;
import org.nuxeo.ecm.webengine.model.Module;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.ecm.webengine.model.ResourceType;
import org.nuxeo.ecm.webengine.model.Validator;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.ecm.webengine.model.impl.DirectoryStack;
import org.nuxeo.ecm.webengine.scripting.ScriptFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultModule
implements Module {
    public static final Log log = LogFactory.getLog(DefaultModule.class);
    protected ModuleHandler handler;
    protected WebEngine engine;
    protected File root;
    protected File skinDir;
    protected Messages messages;
    protected DirectoryStack dirStack;
    protected ModuleHandler base;
    protected ConcurrentMap<String, ScriptFile> fileCache;

    public DefaultModule(ModuleHandler handler) {
        this.handler = handler;
        this.engine = handler.getEngine();
        this.root = new File(this.engine.getRootDirectory(), "modules/" + handler.getBundledApplication().getId());
        this.skinDir = new File(this.root, "skin");
        this.fileCache = new ConcurrentHashMap<String, ScriptFile>();
        this.loadSuperModule();
        this.loadDirectoryStack();
        this.loadMessages();
    }

    @Override
    public WebEngine getEngine() {
        return this.engine;
    }

    @Override
    public String getName() {
        return this.handler.getName();
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.engine.loadClass(className);
    }

    @Override
    public File getRoot() {
        return this.root;
    }

    @Override
    public Module getSuperModule() {
        return this.base != null ? this.base.getModule() : null;
    }

    @Override
    public ScriptFile getSkinResource(String path) throws IOException {
        File file = this.dirStack.getFile(path);
        if (file != null) {
            return new ScriptFile(file);
        }
        return null;
    }

    @Override
    public ScriptFile getFile(String path) {
        int len = path.length();
        if (len == 0) {
            return null;
        }
        char c = path.charAt(0);
        if (c == '.') {
            path = new Path(path).makeAbsolute().toString();
        } else if (c != '/') {
            path = new StringBuilder(len + 1).append("/").append(path).toString();
        }
        try {
            return this.findFile(new Path(path).makeAbsolute().toString());
        }
        catch (IOException e) {
            throw WebException.wrap(e);
        }
    }

    protected ScriptFile findFile(String path) throws IOException {
        File f;
        ScriptFile file = (ScriptFile)this.fileCache.get(path);
        if (file == null && (f = this.dirStack.getFile(path)) != null) {
            file = new ScriptFile(f);
            this.fileCache.put(path, file);
        }
        return file;
    }

    public File getSkinDir() {
        return this.skinDir;
    }

    protected void loadSuperModule() {
        Class<? extends WebEngineModule> superModule = this.handler.getBaseModule();
        if (superModule != null) {
            ModuleHandler mh = this.engine.getApplicationManager().getModuleHandler(superModule.getName());
            if (mh == null) {
                log.warn((Object)("Imported module not found: " + superModule + ". Needed by module: " + this.handler.getBundledApplication().getId()));
            } else {
                this.base = mh;
            }
        }
    }

    protected void loadDirectoryStack() {
        this.dirStack = new DirectoryStack();
        try {
            DirectoryStack ds;
            Module superModule;
            if (this.skinDir.isDirectory()) {
                this.dirStack.addDirectory(this.skinDir);
            }
            if ((superModule = this.getSuperModule()) != null && !(ds = ((DefaultModule)superModule).dirStack).isEmpty()) {
                this.dirStack.getDirectories().addAll(ds.getDirectories());
            }
        }
        catch (IOException e) {
            throw WebException.wrap("Failed to load directories stack", e);
        }
    }

    public void loadMessages() {
        Module superModule = this.getSuperModule();
        this.messages = new Messages(superModule != null ? superModule.getMessages() : null, this);
    }

    @Override
    public Messages getMessages() {
        return this.messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getMessages(String language) {
        log.info((Object)("Loading i18n files for module " + this.getName()));
        File file = new File(this.root, "/i18n/messages_" + language + ".properties");
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            Properties p = new Properties();
            p.load(in);
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>(p);
            return hashMap;
        }
        catch (IOException e) {
            Map<String, String> map = null;
            return map;
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException ee) {
                    log.error((Object)ee);
                }
            }
        }
    }

    @Override
    public List<LinkDescriptor> getActiveLinks(Resource context, String category) {
        throw new UnsupportedOperationException("not yet impl");
    }

    @Override
    public List<LinkDescriptor> getLinks(String category) {
        throw new UnsupportedOperationException("not yet impl");
    }

    public String toString() {
        return this.getName();
    }

    @Override
    @Deprecated
    public void flushCache() {
    }

    @Override
    @Deprecated
    public String getTemplateFileExt() {
        return "ftl";
    }

    @Override
    @Deprecated
    public String getMediaTypeId(MediaType mt) {
        throw new UnsupportedOperationException("deprectaed");
    }

    @Override
    @Deprecated
    public String getSkinPathPrefix() {
        throw new UnsupportedOperationException("deprectaed");
    }

    @Override
    @Deprecated
    public Resource getRootObject(WebContext ctx) {
        throw new UnsupportedOperationException("deprectaed");
    }

    @Override
    @Deprecated
    public AdapterType getAdapter(Resource ctx, String name) {
        throw new UnsupportedOperationException("deprectaed");
    }

    @Override
    @Deprecated
    public List<String> getAdapterNames(Resource ctx) {
        throw new UnsupportedOperationException("deprectaed");
    }

    @Override
    @Deprecated
    public AdapterType[] getAdapters() {
        throw new UnsupportedOperationException("deprectaed");
    }

    @Override
    @Deprecated
    public List<AdapterType> getAdapters(Resource ctx) {
        throw new UnsupportedOperationException("deprectaed");
    }

    @Override
    @Deprecated
    public List<String> getEnabledAdapterNames(Resource ctx) {
        throw new UnsupportedOperationException("deprectaed");
    }

    @Override
    @Deprecated
    public List<AdapterType> getEnabledAdapters(Resource ctx) {
        throw new UnsupportedOperationException("deprectaed");
    }

    @Override
    @Deprecated
    public List<ResourceBinding> getResourceBindings() {
        throw new UnsupportedOperationException("deprectaed");
    }

    @Override
    @Deprecated
    public ResourceType getType(String typeName) {
        throw new UnsupportedOperationException("deprectaed");
    }

    @Override
    @Deprecated
    public ResourceType[] getTypes() {
        throw new UnsupportedOperationException("deprectaed");
    }

    @Override
    @Deprecated
    public Validator getValidator(String docType) {
        throw new UnsupportedOperationException("deprectaed");
    }

    @Override
    @Deprecated
    public boolean isDerivedFrom(String moduleName) {
        throw new UnsupportedOperationException("deprectaed");
    }
}

