/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.app.impl;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.Application;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.ZipUtils;
import org.nuxeo.ecm.webengine.ApplicationManager;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.app.BundledApplication;
import org.nuxeo.ecm.webengine.app.ModuleHandler;
import org.nuxeo.ecm.webengine.app.WebEngineModule;
import org.nuxeo.ecm.webengine.app.extensions.ExtensibleResource;
import org.nuxeo.ecm.webengine.app.extensions.ResourceContribution;
import org.nuxeo.ecm.webengine.app.impl.ModuleRegistry;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentManager;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.RegistrationInfo;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultApplicationManager
implements ApplicationManager {
    private static final Log log = LogFactory.getLog(DefaultApplicationManager.class);
    public static final Pattern PARAMS_PATTERN = Pattern.compile("\\s*([^:\\s]+)\\s*:=\\s*([^;\\s]+)\\s*;?");
    protected WebEngine engine;
    protected LinkedHashMap<String, BundledApplication> apps;
    protected volatile ModuleRegistry registry;
    private final Object lock = new Object();

    public DefaultApplicationManager(WebEngine engine) {
        this.engine = engine;
        this.apps = new LinkedHashMap();
        this.registry = new ModuleRegistry(engine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addApplication(Bundle bundle, Application app) {
        BundledApplication bapp = new BundledApplication(bundle, app);
        Object object = this.lock;
        synchronized (object) {
            this.apps.put(bapp.getId(), bapp);
            this.registry = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeApplication(Bundle bundle) {
        Object object = this.lock;
        synchronized (object) {
            BundledApplication app = (BundledApplication)((Object)this.apps.remove(bundle.getSymbolicName()));
            if (app != null) {
                this.registry = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleRegistry getRegistry() {
        ModuleRegistry _registry = this.registry;
        if (_registry == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.registry != null) {
                    _registry = this.registry;
                } else {
                    _registry = new ModuleRegistry(this.engine);
                    for (BundledApplication app : this.apps.values()) {
                        _registry.addApplication(app);
                    }
                    this.registry = _registry;
                }
            }
        }
        return _registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BundledApplication getApplication(String bundleId) {
        Object object = this.lock;
        synchronized (object) {
            return this.apps.get(bundleId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BundledApplication[] getApplications() {
        Object object = this.lock;
        synchronized (object) {
            return this.apps.values().toArray(new BundledApplication[this.apps.size()]);
        }
    }

    @Override
    public ModuleHandler getModuleHandler(String appId) {
        return this.getRegistry().getModuleHandler(appId);
    }

    @Override
    public ModuleHandler[] getModuleHandlers() {
        return this.getRegistry().getModuleHandlers();
    }

    @Override
    public Object getContribution(Resource target, String key) throws Exception {
        return this.getRegistry().getContribution(target, key);
    }

    @Override
    public List<ResourceContribution> getContributions(ExtensibleResource target, String category) {
        return this.getRegistry().getContributions(target, category);
    }

    @Override
    public List<ResourceContribution> getContributions(Class<? extends ExtensibleResource> target, String category) {
        return this.getRegistry().getContributions(target, category);
    }

    public ResourceContribution getContribution(Class<? extends ExtensibleResource> target, String key) throws Exception {
        return this.getRegistry().getContribution(target, key);
    }

    @Override
    public ModuleHandler getModuleHandlerFor(Class<?> rootResource) {
        return this.getRegistry().getModuleHandlerFor(rootResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() {
        Object object = this.lock;
        synchronized (object) {
            ModuleRegistry _registry = new ModuleRegistry(this.engine);
            for (BundledApplication app : this.apps.values()) {
                try {
                    app.reload(this.engine);
                }
                catch (Exception e) {
                    log.error((Object)("Failed to reload web module: " + app.getId()), (Throwable)e);
                }
                _registry.addApplication(app);
            }
            this.registry = _registry;
        }
    }

    @Override
    public boolean deployApplication(Bundle bundle) throws Exception {
        String webAppEntry = (String)bundle.getHeaders().get("Nuxeo-WebModule");
        if (webAppEntry == null) {
            return false;
        }
        String bundleId = bundle.getSymbolicName();
        if (this.checkHasNuxeoService(bundleId)) {
            throw new WebException("This webengine module should not define a Nuxeo Service, please split up.");
        }
        StringBuilder result = new StringBuilder();
        Map<String, String> attrs = DefaultApplicationManager.readManifestEntryValue(webAppEntry, result);
        String type = result.toString();
        boolean explode = false;
        boolean compat = false;
        if (attrs != null) {
            String v = attrs.get("explode");
            explode = "true".equals(v) ? true : ("false".equals(v) ? false : this.isWebEngineModule(bundle, type));
            v = attrs.get("compat");
            if ("true".equals(v)) {
                compat = true;
            }
        }
        if (explode) {
            File config;
            File moduleDir = this.explodeBundle(bundle);
            if (compat && (config = new File(moduleDir, "module.xml")).isFile()) {
                this.engine.registerModule(config, false);
            }
        }
        try {
            Class<?> appClass = this.engine.loadClass(type);
            Application app = (Application)appClass.newInstance();
            this.addApplication(bundle, app);
        }
        catch (ClassCastException e) {
            throw new Error("Invalid web module specified in MANIFEST for bundle " + bundleId + ". Must be an instance of " + Application.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate web module " + type + " found in bundle " + bundleId, e);
        }
        log.info((Object)("Deployed web module found in bundle: " + bundleId));
        return true;
    }

    protected boolean isWebEngineModule(Bundle b, String type) throws Exception {
        return WebEngineModule.class.isAssignableFrom(b.loadClass(type));
    }

    protected File explodeBundle(Bundle bundle) throws IOException {
        File bundleFile = Framework.getRuntime().getBundleFile(bundle);
        if (bundleFile.isDirectory()) {
            this.engine.getWebLoader().addClassPathElement(bundleFile);
            return bundleFile;
        }
        File moduleRoot = new File(this.engine.getRootDirectory(), "modules/" + bundle.getSymbolicName());
        if (moduleRoot.exists()) {
            if (bundleFile.lastModified() < moduleRoot.lastModified()) {
                this.engine.getWebLoader().addClassPathElement(moduleRoot);
                return moduleRoot;
            }
            FileUtils.deleteTree((File)moduleRoot);
        }
        moduleRoot.mkdirs();
        ZipUtils.unzip((File)bundleFile, (File)moduleRoot);
        this.engine.getWebLoader().addClassPathElement(moduleRoot);
        return moduleRoot;
    }

    protected static Map<String, String> readManifestEntryValue(String value, StringBuilder result) {
        int p = value.indexOf(59);
        if (p > 0) {
            result.append(value.substring(0, p).trim());
            value = value.substring(p + 1);
            HashMap<String, String> params = new HashMap<String, String>();
            Matcher m = PARAMS_PATTERN.matcher(value);
            while (m.find()) {
                params.put(m.group(1), m.group(2));
            }
            return params;
        }
        result.append(value.trim());
        return null;
    }

    protected boolean checkHasNuxeoService(String bundleId) {
        ComponentManager cpManager = Framework.getRuntime().getComponentManager();
        RegistrationInfo regInfo = cpManager.getRegistrationInfo(new ComponentName(bundleId));
        if (null == regInfo) {
            return false;
        }
        String[] serviceNames = regInfo.getProvidedServiceNames();
        return serviceNames != null && serviceNames.length != 0;
    }
}

