/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.app.extensions;

import org.nuxeo.ecm.webengine.app.annotations.ResourceExtension;
import org.nuxeo.ecm.webengine.app.extensions.ExtensibleResource;
import org.nuxeo.ecm.webengine.model.Resource;

public abstract class ResourceContribution {
    protected Class<? extends ExtensibleResource> target;
    protected String key;
    protected String label;
    protected String[] categories;
    protected String[] targetFacets;
    protected boolean translate;

    public ResourceContribution() {
        ResourceExtension anno = this.getClass().getAnnotation(ResourceExtension.class);
        if (anno == null) {
            throw new IllegalStateException("Resource contributions must be annotated with " + ResourceExtension.class + ". Faulty contribution: " + this.getClass());
        }
        this.target = anno.target();
        this.categories = anno.categories();
        this.key = anno.key();
        this.targetFacets = anno.targetFacets();
        this.label = anno.label();
        if (this.label.length() == 0) {
            this.translate = true;
            this.label = this.getClass().getName() + ".label";
        }
    }

    public String getKey() {
        return this.key;
    }

    public String getLinkTarget() {
        return null;
    }

    public String getLabel() {
        return this.label;
    }

    public String[] getCategories() {
        return this.categories;
    }

    public boolean hasCategory(String category) {
        if (this.categories == null || this.categories.length == 0) {
            return false;
        }
        for (int i = 0; i < this.categories.length; ++i) {
            if (!category.equals(this.categories[i])) continue;
            return true;
        }
        return false;
    }

    public boolean accept(Resource target) {
        if (this.targetFacets == null || this.targetFacets.length == 0) {
            return true;
        }
        for (int i = 0; i < this.targetFacets.length; ++i) {
            if (!target.hasFacet(this.targetFacets[i])) continue;
            return true;
        }
        return false;
    }

    public abstract Object newInstance(Resource var1);

    public String toString() {
        return "Contribution " + this.getClass().getName() + " on " + this.target + " at " + this.key;
    }
}

