/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.app.extensions;

import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.app.extensions.ResourceContribution;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;

public abstract class ExtensibleResource
implements Resource {
    protected WebContext ctx;

    public ExtensibleResource() {
        this(WebEngine.getActiveContext());
    }

    public ExtensibleResource(WebContext ctx) {
        this.ctx = ctx;
    }

    @Path(value="{key}")
    public Object dispatch(@PathParam(value="key") String key) {
        try {
            ResourceContribution res = (ResourceContribution)this.getContext().getEngine().getApplicationManager().getContribution(this, key);
            if (res.accept(this)) {
                return res;
            }
            return this.resolveUnmatchedSegment(key);
        }
        catch (Exception e) {
            throw WebException.wrap(e);
        }
    }

    protected Object resolveUnmatchedSegment(String key) {
        throw new WebResourceNotFoundException("No resource found at " + key + " in context " + this);
    }
}

