/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.app;

import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.nuxeo.ecm.webengine.app.annotations.ResourceExtension;
import org.nuxeo.ecm.webengine.app.annotations.ResourceExtensions;
import org.nuxeo.ecm.webengine.app.annotations.WebModule;
import org.nuxeo.ecm.webengine.app.extensions.ResourceContribution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebEngineModule
extends Application {
    protected String name;
    protected Class<?>[] roots;
    protected Class<? extends WebEngineModule> base;
    protected Class<? extends ResourceContribution>[] contributions;

    public WebEngineModule() {
        Class<?> type = ((Object)((Object)this)).getClass();
        WebModule wm = type.getAnnotation(WebModule.class);
        if (wm == null) {
            throw new Error("Invalid web engine application class: " + type + ". Must be annotated with @WebModule");
        }
        this.name = wm.name();
        if (this.name.length() == 0) {
            this.name = type.getSimpleName();
        }
        this.base = wm.base();
        if (Modifier.isAbstract(this.base.getModifiers())) {
            this.base = null;
        }
        this.roots = wm.roots();
        ResourceExtensions rs = type.getAnnotation(ResourceExtensions.class);
        if (rs != null) {
            this.contributions = rs.value();
            for (int i = 0; i < this.contributions.length; ++i) {
                if (this.contributions[i].isAnnotationPresent(ResourceExtension.class)) continue;
                throw new Error("Invalid resource extension class: " + this.contributions[i] + " in application: " + type + ". Must be annotated with @ResourceExtension.");
            }
        }
    }

    public Set<Class<?>> getClasses() {
        HashSet result = new HashSet();
        Class<?>[] rc = this.getRootClasses();
        if (rc != null && rc.length > 0) {
            for (Class<?> c : rc) {
                result.add(c);
            }
        }
        return result;
    }

    public String getName() {
        WebModule wm = ((Object)((Object)this)).getClass().getAnnotation(WebModule.class);
        return wm != null ? wm.name() : null;
    }

    public Class<?>[] getRootClasses() {
        return this.roots;
    }

    public Class<? extends ResourceContribution>[] getContributions() {
        return this.contributions;
    }

    public Class<? extends WebEngineModule> getBaseModule() {
        return this.base;
    }
}

