/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.app;

import java.io.File;
import java.util.List;
import java.util.Vector;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.app.Reloadable;

public class Reloader {
    public static final int DEFAULT_TIMEOUT_CHECK = 2000;
    private int checkTimeout = 0;
    private long lastCheck;
    private long lastModified;
    protected File fileToCheck;
    protected WebEngine engine;
    protected List<Reloadable> listeners;

    public Reloader(WebEngine engine) {
        this(engine, engine.isDevMode() ? 2000 : 0);
    }

    public Reloader(WebEngine engine, int checkTimeout) {
        this.engine = engine;
        this.listeners = new Vector<Reloadable>();
        this.fileToCheck = engine.getRootDirectory();
        this.lastModified = this.fileToCheck.lastModified();
        this.setCheckTimeout(checkTimeout);
    }

    public WebEngine getEngine() {
        return this.engine;
    }

    public void addListener(Reloadable listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Reloadable listener) {
        this.listeners.remove(listener);
    }

    public void setEnabled(boolean isEnabled) {
        this.checkTimeout = 2000;
    }

    public boolean isEnabled() {
        return this.checkTimeout != 0;
    }

    public void setCheckTimeout(int checkTimeout) {
        this.checkTimeout = checkTimeout;
    }

    public int getCheckTimeout() {
        return this.checkTimeout;
    }

    public void check() {
        if (this.checkTimeout == 0) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.lastCheck > (long)this.checkTimeout) {
            this.lastCheck = now;
            long tm = this.fileToCheck.lastModified();
            if (tm > this.lastModified) {
                this.lastModified = tm;
                this.reload();
            }
        }
    }

    public void reload() {
        this.engine.reload();
        for (Reloadable reloadable : this.listeners.toArray(new Reloadable[this.listeners.size()])) {
            reloadable.reload();
        }
    }
}

