/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.app;

import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.app.BundledApplication;
import org.nuxeo.ecm.webengine.app.WebEngineModule;
import org.nuxeo.ecm.webengine.app.extensions.ResourceContribution;
import org.nuxeo.ecm.webengine.app.impl.DefaultModule;
import org.nuxeo.ecm.webengine.model.Module;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleHandler {
    protected WebEngine engine;
    protected BundledApplication app;
    protected volatile Module module;
    private final Object lock = new Object();

    public ModuleHandler(WebEngine engine, BundledApplication app) {
        this.engine = engine;
        this.app = app;
    }

    public WebEngine getEngine() {
        return this.engine;
    }

    public BundledApplication getBundledApplication() {
        return this.app;
    }

    public Bundle getBundle() {
        return this.app.getBundle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Module getModule() {
        Module _module = this.module;
        if (_module == null) {
            Object object = this.lock;
            synchronized (object) {
                _module = this.module != null ? this.module : (this.module = this.buildModule());
            }
        }
        return _module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.module = null;
        }
    }

    public String getName() {
        return ((WebEngineModule)this.app.getApplication()).getName();
    }

    public Class<?>[] getRootClasses() {
        return ((WebEngineModule)this.app.getApplication()).getRootClasses();
    }

    public Class<? extends ResourceContribution>[] getContributions() {
        return ((WebEngineModule)this.app.getApplication()).getContributions();
    }

    public Class<? extends WebEngineModule> getBaseModule() {
        return ((WebEngineModule)this.app.getApplication()).getBaseModule();
    }

    protected Module buildModule() {
        return new DefaultModule(this);
    }
}

