/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.io.api;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.io.DocumentTranslationMap;
import org.nuxeo.ecm.platform.io.api.IOResourceAdapter;
import org.nuxeo.ecm.platform.io.api.IOResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIOResourceAdapter
implements IOResourceAdapter {
    private static final long serialVersionUID = 4399167777434048174L;
    private static final Log log = LogFactory.getLog(AbstractIOResourceAdapter.class);
    protected Map<String, Serializable> properties = new HashMap<String, Serializable>();

    protected AbstractIOResourceAdapter() {
    }

    @Override
    public Map<String, Serializable> getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Map<String, Serializable> properties) {
        this.properties = properties;
    }

    @Override
    public abstract IOResources extractResources(String var1, Collection<DocumentRef> var2);

    @Override
    public abstract IOResources translateResources(String var1, IOResources var2, DocumentTranslationMap var3);

    @Override
    public abstract void storeResources(IOResources var1);

    @Override
    public abstract void getResourcesAsXML(OutputStream var1, IOResources var2);

    @Override
    public abstract IOResources loadResourcesFromXML(InputStream var1);

    protected boolean getBooleanProperty(String propName) {
        Boolean value = (Boolean)this.properties.get(propName);
        if (value == null) {
            return false;
        }
        return value;
    }

    protected void setBooleanProperty(String propName, Serializable propValue) {
        if (propValue == null) {
            return;
        }
        if (propValue instanceof String) {
            this.properties.put(propName, Boolean.valueOf((String)((Object)propValue)));
        } else {
            log.error((Object)String.format("Property %s needs a string representing a boolean: invalid value %s", propName, propValue));
        }
    }

    protected String getStringProperty(String propName) {
        return (String)((Object)this.properties.get(propName));
    }

    protected void setStringProperty(String propName, Serializable propValue) {
        if (propValue == null) {
            return;
        }
        if (!(propValue instanceof String)) {
            log.error((Object)String.format("Property %s needs a string value: invalid value %s", propName, propValue));
        }
        this.properties.put(propName, propValue);
    }

    protected String[] getStringArrayProperty(String propName) {
        return (String[])this.properties.get(propName);
    }

    protected void setStringArrayProperty(String propName, Serializable propValue) {
        if (propValue == null) {
            return;
        }
        if (!(propValue instanceof String[])) {
            log.error((Object)String.format("Property %s needs a string array, invalid value %s", propName, propValue));
        }
        this.properties.put(propName, propValue);
    }
}

